/*+***************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/
 

/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-zisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-zisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

/*+***************************************************************************

$Revision: 1.5 $

****************************************************************************/


#include <specweb99-common.h>


int
main() {
  return Specweb99main((WebInputs_t *)NULL);
  
}


void
GetPostData(WebInputs_t *unused, spec_data_t *pContext) {

/* Place input from POST into Inbuf -- malloc Inbuf, first */


  int Len;
  char * ContentLenStr = getenv("CONTENT_LENGTH");
  int ContentLen = atoi(ContentLenStr);

  /* FAST-CGI note -- use InbufLen to test whether to realloc */
  pContext->Inbuf = malloc(ContentLen + 1);
  Len = read(0, pContext->Inbuf, ContentLen);
  pContext->Inbuf[Len] = '\0';
    
#ifdef DEBUG
  DebugLog("Inbuf = %s\n", pContext->Inbuf);
#endif
}


int 
GetQuery(WebInputs_t *Inputs, spec_data_t *pContext) {

  char *TempStr;
  char *TempCookie;
  char *pStr, *cStr;
  
  int BufLen;

  BufLen = 128;


  if (NULL != (TempStr = getenv("REMOTE_ADDR")) )
    strcpy(pContext->RemoteAddr, TempStr);
  else
    pContext->RemoteAddr[0] = NULL;


  if (NULL == (pContext->QueryString = getenv("QUERY_STRING")) )
      pContext->QueryString = "\0";


  if (NULL == (pContext->QueryMethod = getenv("REQUEST_METHOD")) )
      pContext->QueryMethod = "\0";


  /* cgi GET doesn't do Cookies */
  pContext->CookieStr[0] = NULL;


#ifdef DEBUG
  DebugLog("Leaving GetQuery Query=%s, Meth=%s\n\t Cookie=%s, Addr=%s\n",
	   pContext->QueryString, pContext->QueryMethod, pContext->CookieStr,
	   pContext->RemoteAddr);
#endif
  return 0;
}

/* 
 * FUNCTION:	int Initialize(EXTENSTION_CONTROL_BLOCK *pEcb, 
 *              spec_data_t *pContext)
 *
 * PURPOSE:	Initializes the web_data structure using the inputs
 *              provided by Zeus in the pEcb structure.
 *		
 * ARGUMENTS:	EXTENSION_CONTROL_BLCOK
 *			   *pEcb	ISAPI structure contain "environment"
 *                                      variables and "methods" for getting/
 *                                      returning data.
 *		spec_data_t *pContext	Context structure
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	
 *              
 *		
 */
int 
Initialize(WebInputs_t *Inputs, spec_data_t *pContext) {


  int BufLen;
  char *TempStr;

  /* If we have a problem in initialization, we need to format an error 
     string -- this HTML header is enought */
  const char HtmlHeader[] = "<html>\n"\
    "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
    "<body>\n"\
    "<pre>\n";

  pContext->Buffer = (void *)malloc(BUFLEN);
  if (0 == pContext->Buffer) {
    pContext->BufCurLen += 
      sprintf(&pContext->Buffer[pContext->BufCurLen], 
	      "%sCan't malloc Buffer of size %d: %s", HtmlHeader, BUFLEN, 
	      strerror(errno));
				   
  }  

  if (NULL != (TempStr = getenv("SERVER_SOFTWARE")) )
    strcpy (pContext->ServerSoftware , TempStr);
  else
    pContext->ServerSoftware[0] = NULL;

  if (NULL != (TempStr = getenv("SCRIPT_NAME")))
    strcpy (pContext->ScriptName , TempStr);
  else
    pContext->ScriptName[0] = NULL;

  if (NULL != ( TempStr =getenv("DOCUMENT_ROOT")))
    strcpy (pContext->TopDir, TempStr);
  else 
    strncpy(pContext->TopDir, DEFAULT_TOP_DIR, DEFAULT_TOP_DIR_LEN + 1);

  pContext->LenTopDir = strlen(pContext->TopDir);
  strncpy(pContext->FileName,pContext->TopDir, pContext->LenTopDir);
  
  sprintf(pContext->LogFile, "%s/post.log", POST_LOG_DIR);
  
  /* FAST-CGI note:  do this malloc here if the process will stay
  pContext->Inbuf = malloc(INBUF_INITIAL_LEN);
  pContext->InbufLen = INBUF_INITIAL_LEN;
  */
  pContext->Pid = getpid();
  
  pContext->LastAdReadTime = 0;

  return 0;
}


/* 
 * FUNCTION:	int ReturnPostLog(char *LogFile, char *HtmlStart,
 *				  EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	Returns the post log.  The post log can be huge, so
 *		it is read and returned in 8192 byte chuncks.
 *
 * ARGUMENTS:	char	   *LogFile     Path of Post Log
 *		char       *HtmlStart   Start of HTML page for returning log
 *		EXTENSION_CONTROL_BLOCK
 *			   *pEcb	Control block containing info on
 *					client connection
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	None
 *
 */

int 
ReturnPostLog (char *LogFile, char *HtmlStart, WebInputs_t *Inputs) {

  int Desc;
  struct stat Stat;
  int HtmlLength;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";
  char Header[256];
  int HeaderLen;
  int StartLen;
  int EndLen;

  char Buf[SEND_SIZE];
  int BytesSent;
  int BytesRead;

  /* Open the logfile and read the record count */
  if ((Desc = open(LogFile, O_RDONLY)) == -1)
    sprintf(Buf, "Error opening log file '%s': %s\n",
	    LogFile, strerror(errno));
  else {
    fstat(Desc, &Stat);
    StartLen = strlen(HtmlStart);
    EndLen = strlen (BOILERPLATE_END);
    HtmlLength = Stat.st_size + StartLen + EndLen;


    printf(HeaderFormat, HtmlLength);

    fwrite(HtmlStart, sizeof(char), StartLen, stdout);

    for (BytesSent = 0; BytesSent < Stat.st_size; BytesSent += BytesRead) {
      BytesRead = read(Desc, (void *)Buf, SEND_SIZE);
      fwrite(Buf, sizeof(char), BytesRead, stdout);
    }

    fwrite(BOILERPLATE_END, sizeof(char), EndLen, stdout);
  }
  return 1;
}

int
FinishHtmlAndSendBuffer(WebInputs_t *Inputs, spec_data_t *pContext) {

  int EndLen;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n";


  EndLen = sizeof(BOILERPLATE_END);
  strncpy(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_END, EndLen);
  pContext->BufCurLen += EndLen - 1;

  /* Return headers. */
  printf(HeaderFormat, pContext->BufCurLen);

  /* If we were given a cookie, then we need to return one, too */
  if (pContext->CookieStr[0] != '\0') {
    printf("Set-Cookie: %s\n", pContext->CookieStr);
  }

  printf("\n");

  /* Return complete page */
  fwrite(pContext->Buffer, sizeof(char), pContext->BufCurLen, stdout);
  return 1;
}

  

