/*+***************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/
 

/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-newzisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-zisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

/*+***************************************************************************

$Revision: 1.7 $

****************************************************************************/


#include <specweb99-common.h>
/* Include files from Zeus */
#include <wintypes.h>
#include <unistd.h>
#include <httpext.h>


/* 
 * FUNCTION:	BOOL WINAPI GetExtensionVersion(HSE_VERSION_INFO *pVer)
 *
 * PURPOSE:	ISAPI call that gets executed once when the calling 
 *		process loads this library
 *
 * ARGUMENTS:	HSE_VERSION_INFO  *pVer  passed in structure for setting
 *					 version and description
 *
 * RETURNS:	TRUE
 *
 * COMMENTS:	For more info on ISAPI coding refer to
 *		http://www.microsoft.com/WIN32DEV/APIEXT/ISAPIMRG.HTM
 *
 */
BOOL WINAPI
GetExtensionVersion (HSE_VERSION_INFO *pVer) {
  pVer->dwExtensionVersion = HSE_VERSION_MAJOR;
  strcpy (pVer->lpszExtensionDesc, "SPECweb99 Dynamic GET & POST Test");

  return TRUE;
}


DWORD WINAPI
HttpExtensionProc (EXTENSION_CONTROL_BLOCK *pEcb) {


  return Specweb99main((WebInputs_t *)pEcb);
}


void
GetPostData(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  int BytesRead;
  int BytesToRead;

  /* Check if data is available already (it usually isn't) */
  if (pEcb->cbTotalBytes == pEcb->cbAvailable) {
    memcpy(pContext->Inbuf, (char *)pEcb->lpbData, pEcb->cbTotalBytes);
  }

  else {
    BytesRead = 0;
    BytesToRead = pEcb->cbTotalBytes;
    
    if (pEcb->cbTotalBytes >= pContext->InbufLen) {
      pContext->Inbuf = realloc(pEcb->cbTotalBytes);
      pContext->InbufLen = pEcb->cbTotalBytes;
    }
    
    while (BytesRead != pEcb->cbTotalBytes) {
      pEcb->ReadClient(pEcb->ConnID, &pContext->Inbuf[BytesRead], 
		       &BytesToRead);
      
      BytesRead += BytesToRead;
      BytesToRead = pEcb->cbTotalBytes - BytesRead;
    }
    pContext->Inbuf[BytesRead] = '\0';
#ifdef DEBUG
    DebugLog("Inbuf = %s\n", pContext->Inbuf);
#endif
  }
}

int 
GetQuery(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  char OtherVars[256];
  char *pStr, *cStr;
  
  int BufLen;

  BufLen = 128;


  pEcb->GetServerVariable( pEcb->ConnID, "REMOTE_ADDR", pContext->RemoteAddr,
			   &BufLen);


  pContext->QueryString = (char *)pEcb->lpszQueryString;
  pContext->QueryMethod = (char *)pEcb->lpszMethod;

    /* Determine if there's a Cookie involved */
  BufLen = 256;
  pEcb->GetServerVariable( pEcb->ConnID, "ALL_HTTP", OtherVars,
			   &BufLen);

  pStr = strstr(OtherVars, "HTTP_COOKIE: ");
  cStr = pContext->CookieStr;
  if (NULL != pStr) {
    for ( pStr = pStr + 23; *pStr != '\n' && *pStr != '\0'; pStr++, cStr++)
      *cStr = *pStr;
  }
  *cStr = '\0';

#ifdef DEBUG
  DebugLog("Leaving GetQuery Query=%s, Meth=%s\n\t Cookie=%s, Addr=%s\n",
	   pContext->QueryString, pContext->QueryMethod, pContext->CookieStr,
	   pContext->RemoteAddr);
#endif
  return 0;
}

/* 
 * FUNCTION:	int Initialize(EXTENSTION_CONTROL_BLOCK *pEcb, 
 *              spec_data_t *pContext)
 *
 * PURPOSE:	Initializes the web_data structure using the inputs
 *              provided by Zeus in the pEcb structure.
 *		
 * ARGUMENTS:	EXTENSION_CONTROL_BLCOK
 *			   *pEcb	ISAPI structure contain "environment"
 *                                      variables and "methods" for getting/
 *                                      returning data.
 *		spec_data_t *pContext	Context structure
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	
 *              
 *		
 */
int 
Initialize(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  int BufLen;
  /* If we have a problem in initialization, we need to format an error 
     string -- this HTML header is enought */
  const char HtmlHeader[] = "<html>\n"\
    "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
    "<body>\n"\
    "<pre>\n";



  pContext->Buffer = (void *)malloc(BUFLEN);
  if (0 == pContext->Buffer) {
    pContext->BufCurLen += 
      sprintf(&pContext->Buffer[pContext->BufCurLen], 
	      "%sCan't malloc Buffer of size %d: %s", HtmlHeader, BUFLEN, 
	      strerror(errno));
				   
  }  
  /* pEcb->GetServerVariable() is how you get environment variables */
  BufLen = sizeof(pContext->ServerSoftware);
  pEcb->GetServerVariable( pEcb->ConnID, "SERVER_SOFTWARE", 
			   pContext->ServerSoftware,&BufLen);
  BufLen = sizeof(pContext->ScriptName);
  pEcb->GetServerVariable( pEcb->ConnID, "SCRIPT_NAME", pContext->ScriptName,
			   &BufLen);
  
  if (pEcb->lpszPathTranslated[0] == '\0') 
    memcpy(pContext->TopDir, DEFAULT_TOP_DIR, DEFAULT_TOP_DIR_LEN + 1);
  else
    strcpy(pContext->TopDir, pEcb->lpszPathTranslated);
  
  
  pContext->LenTopDir = strlen(pContext->TopDir);
  memcpy(pContext->FileName,pContext->TopDir, pContext->LenTopDir);
  
  sprintf(pContext->LogFile, "%s/post.log", POST_LOG_DIR);
  
  pContext->Inbuf = malloc(INBUF_INITIAL_LEN);
  pContext->InbufLen = INBUF_INITIAL_LEN;
  
  pContext->Pid = getpid();
  
  pContext->LastAdReadTime = 0;
  return 0;
}


/* 
 * FUNCTION:	int ReturnPostLog(char *LogFile, char *HtmlStart,
 *				  EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	Returns the post log.  The post log can be huge, so
 *		it is read and returned in 8192 byte chuncks.
 *
 * ARGUMENTS:	char	   *LogFile     Path of Post Log
 *		char       *HtmlStart   Start of HTML page for returning log
 *		EXTENSION_CONTROL_BLOCK
 *			   *pEcb	Control block containing info on
 *					client connection
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	None
 *
 */

int 
ReturnPostLog (char *LogFile, char *HtmlStart, WebInputs_t *Inputs) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  int Desc;
  struct stat Stat;
  int HtmlLength;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";
  char Header[256];
  int HeaderLen;
  int StartLen;
  int EndLen;

  char Buf[SEND_SIZE];
  int BytesSent;
  int BytesRead;

  /* Open the logfile and read the record count */
  if ((Desc = open(LogFile, O_RDONLY)) == -1)
    sprintf(Buf, "Error opening log file '%s': %s\n",
	    LogFile, strerror(errno));
  else {
    fstat(Desc, &Stat);
    StartLen = strlen(HtmlStart);
    EndLen = strlen (BOILERPLATE_END);
    HtmlLength = Stat.st_size + StartLen + EndLen;

    HeaderLen = sprintf(Header, HeaderFormat, HtmlLength);
    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;

    pEcb->WriteClient( pEcb->ConnID, HtmlStart, &StartLen, 0);

    for (BytesSent = 0; BytesSent < Stat.st_size; BytesSent += BytesRead) {
      BytesRead = read(Desc, (void *)Buf, SEND_SIZE);
      pEcb->WriteClient( pEcb->ConnID, Buf, &BytesRead, 0);
    }

    pEcb->WriteClient( pEcb->ConnID, BOILERPLATE_END, &EndLen, 0);
  }
  return HSE_STATUS_SUCCESS;
}
/* 
 * FUNCTION:	int RunProgram(char *Path, ...)
 *
 * PURPOSE:     Runs the specified program in a forked process. 
 *		Returns to the caller only after the other program finishes.
 *
 * ARGUMENTS:	char       *Path        Path of the program to run
 *		...			The same arguments that execv expects
 *
 * RETURNS:	0 if all goes well, -1 if it doesn't
 *
 * COMMENTS:	Zeus processes ignore (SIG_IGN) the signal SIGCHLD,
 *		so we turn it on momentarily to wait for the child
 *		to finish .
 *		
 */


int
FinishHtmlAndSendBuffer(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  int EndLen;
  int HeaderLen;
  char Header[128] = HTTP_HEADER_START;
  char *p;

  EndLen = sizeof(BOILERPLATE_END);
  memcpy(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_END, EndLen);
  pContext->BufCurLen += EndLen - 1;



  /* Return headers. */
  p = Header + sizeof(HTTP_HEADER_START) - 1;
  p += MyItoaPos(pContext->BufCurLen, p, 10);

  if (pContext->CookieStr[0] == '\0') {
    memcpy(p, "\r\n\0", 3);
    HeaderLen = p - Header + 2;
    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				     HSE_REQ_SEND_RESPONSE_HEADER, 0,
				     &HeaderLen, (DWORD *) Header) )

    return HSE_STATUS_ERROR;
  }

  else {
    *p++ = '\n';
    memcpy(p, HTTP_SETCOOKIE_START, sizeof(HTTP_SETCOOKIE_START));
    strcpy(p + sizeof(HTTP_SETCOOKIE_START) - 1, pContext->CookieStr);
    HeaderLen = p - Header + sizeof(HTTP_SETCOOKIE_START) 
      + strlen(pContext->CookieStr);

    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;
  }

  /* Return complete page */
#ifdef DEBUG
  HeaderLen = pContext->BufCurLen;
#endif
  pEcb->WriteClient( pEcb->ConnID, pContext->Buffer, &pContext->BufCurLen, 0);
#ifdef DEBUG
  if (pContext->BufCurLen != HeaderLen) 
    DebugLog("Bytes in WriteClient: %d NE Bytes in buffer: %d\n", pContext->BufCurLen, HeaderLen);
#endif
  return HSE_STATUS_SUCCESS;
}

#ifdef TRANSMIT_FILE
int
TransmitFile (WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  HSE_TF_INFO tf;

  char Header[128];
  int HeaderLen;

  /* If we were given a cookie, then we need to return one, too */
  if (pContext->CookieStr[0] != '\0') {

    memcpy(Header, HTTP_SETCOOKIE_XMIT_START, 
	   sizeof(HTTP_SETCOOKIE_XMIT_START));
    strcpy(Header + (sizeof(HTTP_SETCOOKIE_XMIT_START) - 1), pContext->CookieStr);
    HeaderLen = sizeof(HTTP_SETCOOKIE_XMIT_START) + strlen(pContext->CookieStr) - 1;

    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;
  }
  


  memset(&tf, 0, sizeof(tf));

  tf.pHead = (PVOID) pContext->Buffer;
  tf.HeadLength = pContext->BufCurLen;
  pContext->Buffer[pContext->BufCurLen] = '\0';
  tf.pTail = (PVOID) BOILERPLATE_END;
  tf.TailLength = sizeof(BOILERPLATE_END) - 1;
  tf.dwFlags = HSE_IO_SEND_HEADERS | HSE_IO_DISCONNECT_AFTER_SEND |
    HSE_IO_HANDLE_IS_FILENAME;

  tf.hFile = (HANDLE)pContext->FileName;

#ifdef DEBUG
  DebugLog("In Transmit File and header = %s, strlen=%d sizeof=%d\n", tf.pHead,
	   tf.TailLength, sizeof(BOILERPLATE_END));
#endif 

  if (!pEcb->ServerSupportFunction(pEcb->ConnID, HSE_REQ_TRANSMIT_FILE,
				  &tf, 0, 0))
    return MY_TRANSMIT_FILE_ERROR;

#ifdef DEBUG
  if (pContext->BufCurLen != strlen(pContext->Buffer)) 
    DebugLog("%s:Bytes in Header: %d NE Bytes in buffer: %d\n", pContext->BufCurLen, strlen(pContext->Buffer));
#endif

  return HSE_STATUS_SUCCESS;
}

#endif      

  

