/*+***************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/
 

/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-zisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-zisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

/*+***************************************************************************

$Revision: 1.11 $

****************************************************************************/

#ifdef USE_FCGI
#include "fcgi_stdio.h"
#include <stdlib.h>
#include <unistd.h>
#endif

#include <specweb99-common.h>

extern global_spec_data_t gConstants;

int
main() {

#ifdef USE_FCGI
  int i = 0; 
  int fcgi_count = 0;
  int FCGI_fd;
  char Fcgi_fname[256];
  char Fcgi_instances[8];

  char *cwd = getcwd(NULL, 256);
  sprintf(Fcgi_fname, "%s/FCGI_Instances", cwd);
#ifdef DEBUG
  DebugLog("FCGI:cwd = %s\n",cwd);
  sleep (20);
#endif
  if (-1 != (FCGI_fd = open (Fcgi_fname, O_RDONLY, 0))) {
  	i = read (FCGI_fd, Fcgi_instances, sizeof(Fcgi_instances)-1);
	close (FCGI_fd);
	Fcgi_instances[i] = '\0';
  	fcgi_count = atoi(Fcgi_instances);
  }
  if ( fcgi_count > 0) {
    for(i = 1; i < fcgi_count; i++) { 
        if (fork() == 0) break; 
    }
  }
  while (FCGI_Accept() >= 0) {
    Specweb99main((WebInputs_t *)NULL);
  }
#else
    return Specweb99main((WebInputs_t *)NULL);
#endif
  
  
}


void
GetPostData(WebInputs_t *unused, spec_data_t *pContext) {

/* Place input from POST into Inbuf -- malloc Inbuf, first */


  int Len;
  char * ContentLenStr = getenv("CONTENT_LENGTH");
  int ContentLen = atoi(ContentLenStr);

  /* FAST-CGI note -- use InbufLen to test whether to realloc */
  if (0 != pContext->InbufLen)
	pContext->Inbuf = realloc (pContext->Inbuf, ContentLen + 1);
  else {
  	pContext->Inbuf = malloc(ContentLen + 1);
	pContext->InbufLen = ContentLen + 1;
  }
  Len = fread(pContext->Inbuf, sizeof (char), ContentLen , stdin);
  pContext->Inbuf[Len] = '\0';
    
#ifdef DEBUG
  DebugLog("Inbuf = %s\n", pContext->Inbuf);
#endif
}


int 
GetQuery(WebInputs_t *Inputs, spec_data_t *pContext) {

  char *TempStr;
  char *TempCookie;
  
  int BufLen;

  BufLen = 128;


  if (NULL != (TempStr = getenv("REMOTE_ADDR")) )
    strcpy(pContext->RemoteAddr, TempStr);
  else
    pContext->RemoteAddr[0] = '\0';


  if (NULL == (pContext->QueryString = getenv("QUERY_STRING")) )
      pContext->QueryString = '\0';


  if (NULL == (pContext->QueryMethod = getenv("REQUEST_METHOD")) )
      pContext->QueryMethod = '\0';



  pContext->CookieStr[0] = NULL;

  if (NULL != (TempCookie = getenv("HTTP_COOKIE")) ) {
    TempCookie = TempCookie +10;
    strcpy(pContext->CookieStr, TempCookie);
  }
  

#ifdef DEBUG
  DebugLog("Leaving GetQuery Query=%s, Meth=%s\n\t Cookie=%s, Addr=%s\n",
	   pContext->QueryString, pContext->QueryMethod, pContext->CookieStr,
	   pContext->RemoteAddr);
#endif
  return 0;
}

/* 
 * FUNCTION:	int Initialize(EXTENSTION_CONTROL_BLOCK *pEcb, 
 *              spec_data_t *pContext)
 *
 * PURPOSE:	Initializes the web_data structure using the inputs
 *              provided by Zeus in the pEcb structure.
 *		
 * ARGUMENTS:	EXTENSION_CONTROL_BLCOK
 *			   *pEcb	ISAPI structure contain "environment"
 *                                      variables and "methods" for getting/
 *                                      returning data.
 *		spec_data_t *pContext	Context structure
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	
 *              
 *		
 */
int 
Initialize(WebInputs_t *Inputs, spec_data_t *pContext) {


  char *TempStr;

  /* If we have a problem in initialization, we need to format an error 
     string -- this HTML header is enought */
  const char HtmlHeader[] = "<html>\n"\
    "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
    "<body>\n"\
    "<pre>\n";

#ifdef DEBUG
  DebugLog("Initialize: %s\n", pContext->Inbuf);
#endif
  pContext->Buffer = (void *)malloc(BUFLEN);
  if (0 == pContext->Buffer) {
    pContext->Buffer = gConstants.PanicPage;
    pContext->BufCurLen = sprintf(gConstants.PanicPage,
	      "%sCan't malloc Buffer of size %d: %s", HtmlHeader, BUFLEN, 
	      strerror(errno));
    return -1;
  }  

  if (NULL != (TempStr = getenv("SERVER_SOFTWARE")) )
    strcpy (gConstants.ServerSoftware , TempStr);
  else
    gConstants.ServerSoftware[0] = '\0';

  if (NULL != (TempStr = getenv("SCRIPT_NAME")))
    strcpy (gConstants.ScriptName , TempStr);
  else
    gConstants.ScriptName[0] = '\0';

  if (NULL != ( TempStr =getenv("DOCUMENT_ROOT")))
    strcpy (gConstants.TopDir, TempStr);
  else 
    strncpy(gConstants.TopDir, DEFAULT_TOP_DIR, DEFAULT_TOP_DIR_LEN + 1);

  gConstants.LenTopDir = strlen(gConstants.TopDir);
  strncpy(pContext->FileName,gConstants.TopDir, gConstants.LenTopDir);
  
  sprintf(gConstants.LogFile, "%s/post.log", POST_LOG_DIR);
  
  /* FAST-CGI note:  do this malloc here if the process will stay
  pContext->Inbuf = malloc(INBUF_INITIAL_LEN);
  pContext->InbufLen = INBUF_INITIAL_LEN;
  */
  gConstants.Pid = getpid();
  
  gConstants.LastAdReadTime = 0;

  return 0;
}


/* 
 * FUNCTION:	int ReturnPostLog(char *LogFile, char *HtmlStart,
 *				  EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	Returns the post log.  The post log can be huge, so
 *		it is read and returned in 8192 byte chuncks.
 *
 * ARGUMENTS:	char	   *LogFile     Path of Post Log
 *		char       *HtmlStart   Start of HTML page for returning log
 *		EXTENSION_CONTROL_BLOCK
 *			   *pEcb	Control block containing info on
 *					client connection
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	None
 *
 */

int 
ReturnPostLog (char *LogFile, char *HtmlStart, WebInputs_t *Inputs) {

  int Desc;
  struct stat Stat;
  int HtmlLength;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";
  int StartLen;
  int EndLen;

  char Buf[SEND_SIZE];
  int BytesSent;
  int BytesRead;

  /* Open the logfile and read the record count */
  if ((Desc = open(LogFile, O_RDONLY)) == -1)
    sprintf(Buf, "Error opening log file '%s': %s\n",
	    LogFile, strerror(errno));
  else {
    fstat(Desc, &Stat);
    StartLen = strlen(HtmlStart);
    EndLen = strlen (BOILERPLATE_END);
    HtmlLength = Stat.st_size + StartLen + EndLen;


    printf(HeaderFormat, HtmlLength);

    fwrite(HtmlStart, sizeof(char), StartLen, stdout);

    for (BytesSent = 0; BytesSent < Stat.st_size; BytesSent += BytesRead) {
      BytesRead = read(Desc, (void *)Buf, SEND_SIZE);
      fwrite(Buf, sizeof(char), BytesRead, stdout);
    }

    fwrite(BOILERPLATE_END, sizeof(char), EndLen, stdout);
  }
  /* Used to be return 1 to match ISAPI SUCCESS*/
  return 0;
}

int
FinishHtmlAndSendBuffer(WebInputs_t *Inputs, spec_data_t *pContext) {

  int EndLen;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n";


  EndLen = sizeof(BOILERPLATE_END);
  strncpy(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_END, EndLen);
  pContext->BufCurLen += EndLen - 1;

  /* Return headers. */
  printf(HeaderFormat, pContext->BufCurLen);

  /* If we were given a cookie, then we need to return one, too */
  if (pContext->CookieStr[0] != '\0') {
    printf("Set-Cookie: %s\n", pContext->CookieStr);
  }

  printf("\n");

  /* Return complete page */
  fwrite(pContext->Buffer, sizeof(char), pContext->BufCurLen, stdout);
  /* Used to be return 1 to match ISAPI SUCCESS*/
  return 0;
}

  

