/*+***************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/


#ifndef SPECWEB99COMMON_H 
#define SPECWEB99COMMON_H 

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef _WIN32

#include <io.h>
#include <windows.h>
#include <process.h>
#define PATH_MAX _MAX_PATH
#define DEFAULT_TOP_DIR "c:\\inetpub\\wwwroot"
#define POST_LOG_DIR DEFAULT_TOP_DIR
#define sleep(sec) Sleep(1000 * sec)
#define getpid _getpid


#else 

#include <sys/wait.h>
#include <unistd.h>
#define POST_LOG_DIR "/postlogs"
#define DEFAULT_TOP_DIR "/www"
#endif

#define BOILERPLATE_START \
"<html>\n"\
"<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
"<body>\n"\
"<p>SERVER_SOFTWARE = %s\n"\
"<p>REMOTE_ADDR = %s\n"\
"<p>SCRIPT_NAME = %s\n"\
"<p>QUERY_STRING = %s\n"\
"<pre>\n"

#define HTML_START1 \
"<html>\n"\
"<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
"<body>\n"\
"<p>SERVER_SOFTWARE = "
#define HTML_START2 "\n<p>REMOTE_ADDR = "
#define HTML_START3 "\n<p>SCRIPT_NAME = "
#define HTML_START4 "\n<p>QUERY_STRING = "
#define HTML_START5 "\n<pre>\n"

#define BOILERPLATE_END "\n</pre>\n</body></html>\n"

#define HTTP_COOKIE_STR "HTTP_COOKIE:"

#ifdef _WIN32
#define MYCOOKIE_STR "my_cookie="
#else
#define MYCOOKIE_STR " my_cookie="
#endif

#define HTTP_HEADER_START "Content-Type: text/html\nContent-Length: "
#define HTTP_SETCOOKIE_START "Set-Cookie: "
#define HTTP_SETCOOKIE_XMIT_START "Content-Type: text/html\nSet-Cookie: "

#define CAD_SCAN_STR "<!WEB99CAD><IMG SRC=\"/file_set/dirNNNNN/classX_Y\"><!/WEB99CAD>"
#define CAD_REPLACE_LOC  sizeof("<!WEB99CAD><IMG SRC=\"") - 1;


#define ERROR_MSG_MAX 256
#define BUFLEN 128*1024*10
#define INBUF_INITIAL_LEN 256
#define ERROR_NO_DOC_TOP "Can't find top of document tree, please configure value CGI script manually.\n"


#define DEFAULT_TOP_DIR_LEN strlen(DEFAULT_TOP_DIR)

#define TRUE 1
#define FALSE 0

#define MY_TRANSMIT_FILE_ERROR -50797

#define SEND_SIZE 8192

#define CUSTOM_AD_FILE "Custom.Ads"
#define CUSTOM_AD_RECLEN 39
#define CUSTOM_AD_CREATE "cadgen99"
#define MAX_ADS 360

#define USER_PERS_FILE "User.Personality"
#define USER_PERS_RECLEN 15
#define USER_PERS_CREATE "upfgen99"


#define CUSTOM_AD 0
#define USER_PERS 1

#define GENDER_MASK	0x30000000
#define AGE_MASK	0x0f000000
#define REGION_MASK	0x00f00000
#define INTEREST1_MASK	0x000ffc00
#define INTEREST2_MASK	0x000003ff




enum ReqTypes { GET, POST, RESET, FETCH, TEST, ROOT };


/* Structure to keep parsed inputs from POST */
typedef struct _post_struct_t {
  int Dir;
  int Class;
  int Num;
  int Client;
  int Cookie;
} post_struct_t;

typedef  struct _ad_struct_t {
  int Dems;
  int GenWt;
  int AgeWt;
  int RegWt;
  int Int1Wt;
  int Int2Wt;
  int Expire;
  int MinimumMatchWeight;
} ad_struct_t;

/* Structure containing all the static variables (except for Inited and the
   few in DebugLog.  The use of this structure in this program is not 
   thread safe
   */
typedef struct _req_data_t {

  /* Filled in for every request */
  char *Buffer;			/* Buffer for all return data */
  int BufCurLen;	/* Current length of characters in Buffer */
  char *Inbuf;			/* Buffer for taking POST input */
  int InbufLen;	/* Length of Inbuf */
  char RemoteAddr[128];		/* address of client making request */
  char *QueryString;		/* Query -- excluding GET/POST/... part */
  char *QueryMethod;		/* see enumerated type ReqTypes */
  char CookieStr[64];		/* Cookie string -- NULL if none sent */
  char CadStr[32];
  char FileName[PATH_MAX];	/* FileName for GET and POST to return */
  


} spec_data_t;

typedef struct _global_spec_data_t {
  char *VersionStr;		/* Version of this code */
  char ServerSoftware[128];	/* Name of server software */
  char ScriptName[128];		/* Name of script */
  char TopDir[PATH_MAX];	/* Top directory */
  int LenTopDir;		/* strlen of TopDir */
  char FileName[PATH_MAX];	/* FileName for GET and POST to return */
  char LogFile[PATH_MAX];	/* Log file */
  int Pid;			/* Process ID */
  int LastAdReadTime;		/* Last timestamp of CustomAd file read in */
  ad_struct_t Ads[MAX_ADS];	/* Space for Custom Ads */
  int *UDemog;			/* Place to malloc User Demographics */
  FILE *UserDemFd;		/* File descriptor for User Demographics file */
  char PanicPage[ERROR_MSG_MAX];  /* In case initialize fails */
} global_spec_data_t;  


int CustomAdRotation(spec_data_t *pContext, char *Buf);
int CustomAdTextReplace(char *ReplacementStr, char  *Text);
void DoOutput(char *Buf, int Len);
int DoPost( spec_data_t *pContext, char *Buf);
int DoReset(char *ResetString, spec_data_t *pContext, char *Buf);
int DoTest ( char *LogFile, char *Buf );
int ReadCustomData(char *Path, ad_struct_t *AdPtr, int *UserDems, int DataType);
int ReadFileIntoBuffer(char *FileName, char *Buf, int BufSize);
int RunProgram(char *Path, ...);
int WriteLog (spec_data_t *pContext, post_struct_t *pPost, char *File);
void DebugLog (char *Format, ...);
int MyItoaPos( int val, char *buf, int radix);



typedef void *WebInputs_t;

/* Routines that are specific for each implementation */
void GetPostData(WebInputs_t *WebInputs, spec_data_t *pContext);
int GetQuery(WebInputs_t *WebInputs, spec_data_t *pContext);
int Initialize (WebInputs_t *WebInputs, spec_data_t *pContext);
int ReturnPostLog(char *LogFile, char *HtmlStart,WebInputs_t *WebInputs);
int FinishHtmlAndSendBuffer(WebInputs_t *WebInputs,spec_data_t *pContext);
int Specweb99main(WebInputs_t *WebInputs);
int TransmitFile(WebInputs_t *WebInputs,spec_data_t *pContext);

#endif
