/*+***************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/
 

/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-zisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-newzisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

/*+***************************************************************************

$Revision: 1.18 $

****************************************************************************/


#include <specweb99-common.h>
#include <sys/mman.h>
#include <alpha/builtins.h>

/* Include files from Zeus */
#include <httpext.h>
#include <wintypes.h>

#include <unistd.h>


static int Inited = FALSE;
static spec_data_t Context, *pContext;
global_spec_data_t gConstants;

/* #ifdef DEBUG */
static FILE *LogFd = 0 ;
/* #endif */



int 
Specweb99main(WebInputs_t *WebInputs) {

  int TempLen;
  int RetVal;

  int Request;		/* Type of request (i.e. GET, POST, FETCH, etc. */
  int TextLen;

  int len;
  char *errorstr;
  char *FileStart;


  /* Assign some handy pointers*/
  pContext = &Context;

  pContext->BufCurLen = 0;
 
  /* If 1st time through, set up the "static" variables kept in the 
     Context structure */
  if (!Inited) {

      if (-1 == Initialize(WebInputs, pContext)) {
	return FinishHtmlAndSendBuffer(WebInputs, pContext);
      }
      Inited = TRUE;
      gConstants.VersionStr = VERSION;
      
  }
 
  Request = GetQuery(WebInputs, pContext);

   /* Make the start of the Html page */
  /*
  pContext->BufCurLen += 
    sprintf(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_START, 
	    pContext->ServerSoftware, pContext->RemoteAddr,
	    pContext->ScriptName, pContext->QueryString);
	    */

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START1, SZ_HTML_START1);
  pContext->BufCurLen += SZ_HTML_START1;
  memcpy(&pContext->Buffer[pContext->BufCurLen], gConstants.ServerSoftware, gConstants.LenServerSoftware);
  pContext->BufCurLen += gConstants.LenServerSoftware;


  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START2, SZ_HTML_START2);
  pContext->BufCurLen += SZ_HTML_START2;
  len = strlen(pContext->RemoteAddr);
  memcpy(&pContext->Buffer[pContext->BufCurLen], pContext->RemoteAddr, len );
  pContext->BufCurLen += len;

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START3, SZ_HTML_START3);
  pContext->BufCurLen += SZ_HTML_START3;
  memcpy(&pContext->Buffer[pContext->BufCurLen], gConstants.ScriptName, 
    gConstants.LenScriptName);
  pContext->BufCurLen += gConstants.LenScriptName;

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START4, SZ_HTML_START4);
  pContext->BufCurLen += SZ_HTML_START4;
  len = strlen(pContext->QueryString);
  memcpy(&pContext->Buffer[pContext->BufCurLen], pContext->QueryString, len );
  pContext->BufCurLen += len;

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START5, SZ_HTML_START5);
  pContext->BufCurLen += SZ_HTML_START5;


  pContext->Buffer[pContext->BufCurLen] = '\0';


  /* Parse the command */

  switch (Request) {
    case GET_PAGE:
      strcpy(&pContext->FileName[gConstants.LenTopDir], pContext->QueryString);
      TransmitFile(WebInputs, pContext);
      break;

    case GET_CAD:
      strcpy(&pContext->FileName[gConstants.LenTopDir], pContext->QueryString);
      FileStart = &pContext->Buffer[pContext->BufCurLen];
      pContext->BufCurLen +=
            CustomAdRotation(pContext, &pContext->Buffer[pContext->BufCurLen]);
      if (strstr (pContext->FileName, "class1") != NULL ||
           strstr (pContext-> FileName, "class2" )  != NULL ) {
        TextLen  = ReadFileIntoBuffer(pContext->FileName,
                     &pContext->Buffer[pContext->BufCurLen],
                     BUFLEN - pContext->BufCurLen);
        pContext->BufCurLen += TextLen;
        if (-1 == CustomAdTextReplace(pContext->CadStr,FileStart,TextLen)) {
             pContext->BufCurLen+= sprintf
                (&pContext->Buffer[pContext->BufCurLen],
                "Error in Include Files routine\n");
        }
        FinishHtmlAndSendBuffer(WebInputs, pContext);
      } else { /* class0 or class 3 */
        TransmitFile(WebInputs, pContext);
      }
      break;

    case POST_PAGE:
      GetPostData(WebInputs, pContext);
      if (0 == DoPost(pContext, &pContext->Buffer[pContext->BufCurLen])) {
        TransmitFile(WebInputs, pContext);
      } else {
        FinishHtmlAndSendBuffer(WebInputs, pContext);
      }
      break;

    case CMD_RESET:
      pContext->BufCurLen += DoReset(&pContext->QueryString[14], pContext, 
		     &pContext->Buffer[pContext->BufCurLen]);
      FinishHtmlAndSendBuffer(WebInputs, pContext);
      break;

    case CMD_FETCH:
      ReturnPostLog (gConstants.LogFile, pContext->Buffer, WebInputs);
      break;

    case CMD_VERSION:
      pContext->BufCurLen += sprintf (&pContext->Buffer[pContext->BufCurLen],
				      "Version = %s", gConstants.VersionStr);
      FinishHtmlAndSendBuffer(WebInputs, pContext);
      break;

    case NO_QUERY:
      pContext->BufCurLen += sprintf(&pContext->Buffer[pContext->BufCurLen], 
				     "No query string was set\n");
      FinishHtmlAndSendBuffer(WebInputs, pContext);
      break;
  }

  return (0);
}


/* 
 * FUNCTION:	int CustomAdRotation(spec_data_t *pContext, char *Buf);
 *
 * PURPOSE:	Implements the custom ad rotation scheme.  In this scheme
 *		the cookie from the current request is matched against
 *		cookies in last 30 seconds of the post log, returning
 *		the number of matches found.
 *		
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *		int	   Cookie       Cookie to search for
 *              int        *pFound      place to record # of found matches
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If everthing works, nothing is ever written to Buf.  It
 *		is only there for returning error strings.
 */

int 
CustomAdRotation( spec_data_t *pContext, char *Buf) {

  char FileName[PATH_MAX];
  struct stat FStats;
  int UserCt;
  int MyUserId;
  int LastAd;
  char *Ptr;
  int AdIndex;
  int ComboDemog;
  int Weight;
  int Expire;
  int CurrTime; 
  int dirlen;
  static char mydir[6];
  static int flg = 0;
  static char class_suffix[36][4] = {
   {"0_0"},{"0_1"},{"0_2"},{"0_3"},{"0_4"},{"0_5"},{"0_6"},{"0_7"},{"0_8"},
   {"1_0"},{"1_1"},{"1_2"},{"1_3"},{"1_4"},{"1_5"},{"1_6"},{"1_7"},{"1_8"},
   {"2_0"},{"2_1"},{"2_2"},{"2_3"},{"2_4"},{"2_5"},{"2_6"},{"2_7"},{"2_8"},
   {"3_0"},{"3_1"},{"3_2"},{"3_3"},{"3_4"},{"3_5"},{"3_6"},{"3_7"},{"3_8"}};

  if (flg == 0) {
	if (CreateResetFlag() != -1) flg++;
  }

if (gConstants.ResetGeneration != *gConstants.CurrentResetGeneration) {

  /* Check to see if there's a new User.Personality file */
  if (-1 == stat( gConstants.UserPersFile, &FStats) )
    return sprintf(Buf, "Error stating %s: %s", gConstants.UserPersFile, 
			strerror(errno));
  if (FStats.st_mtime > gConstants.LastAdReadTime) {

    gConstants.LastAdReadTime = FStats.st_mtime;

    /* Ruth - put a critical section around this!!!! */
    /* Get User Personality data - but first malloc a structure to hold it*/
    UserCt = FStats.st_size / USER_PERS_RECLEN;
    if (0 == (gConstants.UDemog = 
	      (int *)realloc(gConstants.UDemog, UserCt * sizeof(int))))
      return sprintf(Buf, "Error re-allocing UDemog: %s", strerror(errno));

    if (-1 == ReadCustomData(gConstants.UserPersFile, 0, gConstants.UDemog, 
		USER_PERS))
      return sprintf(Buf, "Error reading user pers. data: %s", strerror(errno));

#ifdef DEBUG
    DebugLog("FLen = %d, UserCt = %d, StructSize = %d\n",
	     FStats.st_size, UserCt, sizeof(*gConstants.UDemog));
#endif

    /* Get Custom Ad data */
    if (-1 == ReadCustomData(gConstants.CustomAdFile, gConstants.Ads, 0, CUSTOM_AD)) {
      return sprintf(Buf, "Error in ReadCustomAds: %s", strerror(errno));
    }

  }
gConstants.ResetGeneration = *gConstants.CurrentResetGeneration;
}
  
  /* Parse the incoming Cookie data */
  /* Format of input: user_id=<x>&last_ad=<y> */
  MyUserId = strtol(pContext->CookieStr + 8, &Ptr, 10) - 10000;
  LastAd = atol(Ptr + 9);

  /* Find the user profile */
  AdIndex = LastAd + 1;
  
  for (AdIndex = LastAd + 1; AdIndex != LastAd; AdIndex ++) {
    if (MAX_ADS <= AdIndex)
      AdIndex = 0;
    Weight = 0;
    ComboDemog = gConstants.UDemog[MyUserId] & gConstants.Ads[AdIndex].Dems;
    if (ComboDemog & GENDER_MASK) 
      Weight += gConstants.Ads[AdIndex].GenWt;
    if (ComboDemog & AGE_MASK) 
      Weight += gConstants.Ads[AdIndex].AgeWt;
    if (ComboDemog & REGION_MASK) 
      Weight += gConstants.Ads[AdIndex].RegWt;
    if (ComboDemog & INTEREST1_MASK) 
      Weight += gConstants.Ads[AdIndex].Int1Wt;
    if (ComboDemog & INTEREST2_MASK) 
      Weight += gConstants.Ads[AdIndex].Int2Wt;
      /*
#ifdef DEBUG
    DebugLog("%03d/%03d  UserD = %08x AdD = %08x ComboD = %08x",
	     MyUserId, AdIndex,
	     gConstants.UDemog[MyUserId], gConstants.Ads[AdIndex].Dems,
	     ComboDemog);
    DebugLog("   %02d:%02d:%02d:%02d:%02d Total=%3d Match=%3d\n",
	     gConstants.Ads[AdIndex].GenWt,
	     gConstants.Ads[AdIndex].AgeWt,
	     gConstants.Ads[AdIndex].RegWt,
	     gConstants.Ads[AdIndex].Int1Wt,
	     gConstants.Ads[AdIndex].Int2Wt,
	     Weight, gConstants.Ads[AdIndex].MinimumMatchWeight);
#endif
*/      
    if (Weight >= gConstants.Ads[AdIndex].MinimumMatchWeight)
      break;
  }

  if (gConstants.TimePtr != NULL) 
	CurrTime = *gConstants.TimePtr;
  else
  	CurrTime = time(NULL); 
	
  if (CurrTime > gConstants.Ads[AdIndex].Expire)
	Expire = 1;
  else
	Expire = 0;
    
#ifdef DEBUG
  DebugLog("Cookie in = %s\n", pContext->CookieStr);
#endif

  /* Place the found ad information in the Cookie_Str and also
     make a replacement filename out of information in the AdIndex */
/*  sprintf(pContext->CookieStr, "found_cookie=Ad_id=%d&Ad_weight=%d&Expired=%d\r\n\r\n", AdIndex,Weight,Expire); */

  memcpy(pContext->CookieStr, "found_cookie=Ad_id=", 19);
  Ptr  = pContext->CookieStr + 19;
  Ptr += MyItoaPos(AdIndex, Ptr, 10);  
  memcpy(Ptr, "&Ad_weight=", 11);
  Ptr += 11;
  Ptr += MyItoaPos(Weight, Ptr, 10);
  memcpy(Ptr, "&Expired=", 9);
  Ptr += 9;
  Ptr += MyItoaPos(Expire, Ptr, 10);
  memcpy(Ptr, "\r\n\r\n\0", 5);
  
/*  sprintf(pContext->CadStr, "/file_set/dir%05d/class%d_%d", 
	  AdIndex / 36, ((AdIndex % 36) / 9), AdIndex % 9); */

  memcpy(pContext->CadStr, "/file_set/dir00000/class",24);
  Ptr  = pContext->CadStr + 24;
  memcpy (Ptr, class_suffix[AdIndex%36], 4);
/*****
  Ptr += MyItoaPos(((AdIndex % 36) / 9), Ptr, 10);
  memcpy(Ptr, "_", 1);
  Ptr += 1;
  Ptr += MyItoaPos((AdIndex % 9), Ptr, 10);
  memcpy(Ptr, "\0", 1);
*****/

  dirlen = MyItoaPos((AdIndex / 36), mydir, 10);
  if (1 == dirlen) {
	memcpy(pContext->CadStr + 17, mydir, 1);
  }
  else if (2 == dirlen) {
	memcpy(pContext->CadStr + 16, mydir, 2);
  } 
  else if (3 == dirlen) {
	memcpy(pContext->CadStr + 15, mydir, 3);
  } 
  else if (4 == dirlen) {
	memcpy(pContext->CadStr + 14, mydir, 4);
  } 
  else if (5 == dirlen) {
	memcpy(pContext->CadStr + 13, mydir, 5);
  } 


#ifdef DEBUG
  DebugLog("Cookie out = %s\n", pContext->CookieStr);
#endif
  return 0;
}



/* 
 * FUNCTION:	int DoPost( spec_data_t *pContext, char *Buf)
int DoPost( spec_data_t *pContext, char *Buf);
 *
 * PURPOSE:	Implement dynamic POST.  Parses the input data, fetches
 *		the file requested, into the buffer then writes the logfile.
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	None.
 *		
 */

int
DoPost( spec_data_t *pContext, char *Buf) {

  char *pChar, *pCmd, *pFileName, *pCS, *ptr;
  post_struct_t PostData;
  char mycookieStr[LEN64];
  int Error = 0;
  int done;



  pChar = pCmd = pContext->Inbuf;
  Error = 5;
  done = 0;


  /* Parse the incoming Cookie data to get my_cookie   */
  /* value (user_id) to return with Set-cookie         */
  /* Format of input: user_id=<x>&last_ad=<y>          */

  memcpy(mycookieStr, "my_cookie=", 10);
  pCS  = mycookieStr + 10;
  *pCS = '\0';

  PostData.Cookie = pContext->CookieStr + 8;
  ptr = pContext->CookieStr + 8;
  for (PostData.Cookie_len=0; *ptr != '&'; PostData.Cookie_len++) ptr++;
  memcpy(pCS,PostData.Cookie,PostData.Cookie_len);
  pCS += PostData.Cookie_len;
  memcpy(pCS, "\r\n\r\n\0", 5);
  pCS=pContext->CookieStr;
  memcpy(pCS,mycookieStr,(10+PostData.Cookie_len+5));
  PostData.Cookie = pCS + 10;

  
#ifdef DEBUG
  DebugLog("Forming PostData.Cookie: CookieStr = %s, Cookie = %d\n",
	   pContext->CookieStr, PostData.Cookie);
#endif

  while( !done) {
    if ('&' == *pChar  || 0 == *pChar) {
      if (!strncmp(pCmd, "urlroot=", 8)) {      
	PostData.UrlRoot = pCmd + 8;
	PostData.UrlRoot_len = pChar - PostData.UrlRoot;
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "dir=", 4)) {
	PostData.Dir = (pCmd + 4);
	PostData.Dir_len = pChar - PostData.Dir;
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "class=", 6)) {
	PostData.Class = pCmd + 6;
	PostData.Class_len = pChar - PostData.Class;
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "num=", 4)) {
	PostData.Num = pCmd + 4;
	PostData.Num_len = pChar - PostData.Num;
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "client=", 7)) {
	PostData.Client = pCmd + 7;
	PostData.Client_len = pChar - PostData.Client;
	pCmd = pChar + 1;
	Error--;
      }
    }
    if (0 == *pChar) 
      done = 1;
    else 
      pChar++;
    
  }
  
  pChar = PostData.UrlRoot + PostData.UrlRoot_len;
  *pChar = '\0';
  pChar = PostData.Dir + PostData.Dir_len;
  *pChar = '\0';
  pChar = PostData.Class + PostData.Class_len;
  *pChar = '\0';
  pChar = PostData.Num + PostData.Num_len;
  *pChar = '\0';
  pChar = PostData.Client + PostData.Client_len;
  *pChar = '\0';

  if (Error) {
    pContext->BufCurLen += 
      sprintf (Buf, "Incorrect POST Input: '%s', UrlRoot = %s,dir='%s',"
	       " class='%s', num='%s', client='%s', #input=%d\n",
	       pContext->Inbuf, PostData.UrlRoot, PostData.Dir, PostData.Class, 
	       PostData.Num, 
	       PostData.Client, Error);
    return -1;
  }
  
  /* sprintf(pContext->FileName, "%s%sdir%05d/class%d_%d", gConstants.TopDir, 
	  UrlRoot, PostData.Dir,
	  PostData.Class, PostData.Num);
  */
  pFileName = pContext->FileName;
  memcpy(pFileName,gConstants.TopDir,gConstants.LenTopDir);
  pFileName += gConstants.LenTopDir;
  memcpy(pFileName,PostData.UrlRoot,PostData.UrlRoot_len);
  pFileName += PostData.UrlRoot_len;
  memcpy(pFileName,"dir",3);
  pFileName += 3;
  memcpy(pFileName,PostData.Dir,PostData.Dir_len);
  pFileName += PostData.Dir_len;
  memcpy(pFileName,"/class",6);
  pFileName += 6;
  *pFileName = *PostData.Class;
  pFileName++;
  *pFileName = '_';
  pFileName++;
  *pFileName = *PostData.Num;
  pFileName++;
  *pFileName = '\0';
  
  
  if (WriteLog(pContext, &PostData, pContext->FileName) == -1) {
    pContext->BufCurLen += 
      sprintf(Buf, "Error writing log file '%s': %s\n", 
	      gConstants.LogFile, strerror(errno));
    return -1;
  }

  return 0;
}


/* 
 * FUNCTION:	int DoReset(spec_data_t *pContext, char *Buf)
 *
 * PURPOSE:	Resets the post log to 0 records.  If no post.log exists
 *		creates a new one.
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If everthing works, nothing is ever written to Buf.  It
 *		is only there for returning error strings.
 */

int
DoReset( char *ResetString, spec_data_t *pContext, char *Buf) {
  /* Reset will truncate the file, we unlink and then open a new file with a
     count of 0.  */
  FILE *Fd;
  char ProgramPath[PATH_MAX];
  char *pStr;
  char *MaxLoadStr = NULL;
  char *PtTimeStr = NULL;
  char *ThreadStr = NULL;
  char *ExpiredStr  = NULL;
  char *ExpiredStr2 = NULL;
  char *RootStr = NULL;
  char *Arg[10];
  int ArgCnt;
  int len = 0;
  int retval;
  int i;


  /* The cookie code checks mod-time from stat to figure out if a new
     file has been created.  This only has 1-second granularity, so if multiple
     resets happen in a second, the mtime looks identical -- with this sleep,
     that never happens */
  sleep(1);

  /* Place each ampersand separated argument into the Arg list */
  Arg[0] = ResetString;
  for (ArgCnt = 0, pStr = ResetString; *pStr != '\0'; pStr++) {
    if ('&' == *pStr) {
      *pStr = '\0';
      ArgCnt++;
      Arg[ArgCnt] = pStr + 1;
    } 
    else if ( ',' == *pStr) {
      *pStr = '\0';
      ArgCnt++;
      Arg[ArgCnt] = pStr + 1;
    }
  }
    
  /* Now find all the strings we expect and make sure they're all present */
  for (i = 0; i <= ArgCnt; i++) {
    if ( 0 != strstr(Arg[i], "maxload=")) {
      MaxLoadStr = Arg[i] + sizeof("maxload=") - 1;
    }
    else if ( 0 != strstr(Arg[i], "pttime="))
      PtTimeStr = Arg[i] + sizeof("pttime=") - 1;
    else if ( 0 != strstr(Arg[i], "maxthread="))
      ThreadStr = Arg[i] + sizeof("maxthread=") - 1;
    else if ( 0 != strstr(Arg[i], "exp=")) {
      ExpiredStr = Arg[i] + sizeof("exp=") - 1;
      ExpiredStr2 = Arg[i+1];
    }
    else if ( 0 != strstr(Arg[i], "urlroot=")) {
      /* Skip the '//servername/' part */
      RootStr = strstr(Arg[i], "//") + 2;
      RootStr = strchr(RootStr, '/') + 1;
    }
  }
  if (!PtTimeStr || !MaxLoadStr || !ThreadStr || !ExpiredStr || !RootStr) 
    return sprintf(Buf,
		   "Missing an arg: Found maxload=%s pttime=%s maxthread=%s exp=%s,%s, urlroot=%s",
		   MaxLoadStr, PtTimeStr, ThreadStr, ExpiredStr, 
		   ExpiredStr2, RootStr);


  /* Run program to make user personality file */
  sprintf(ProgramPath, "%s/%s", gConstants.TopDir, USER_PERS_CREATE);
  if (-1 == (retval = 
	     RunProgram(ProgramPath, USER_PERS_CREATE, "-C", gConstants.TopDir, 
			"-n", MaxLoadStr, "-t", ThreadStr, NULL)))
    return sprintf(Buf, "Error running %s - Error %d: %s\n",
		   ProgramPath, errno, strerror(errno));

  len += sprintf(&Buf[len], "%s returned with value %d\n", USER_PERS_CREATE,
		 retval);
 
  /* Run program to make custom ad file */
  sprintf(ProgramPath, "%s/%s", gConstants.TopDir, CUSTOM_AD_CREATE);


  if (-1 == (retval = RunProgram(ProgramPath, CUSTOM_AD_CREATE, "-C",
				 gConstants.TopDir, "-e", PtTimeStr, "-t", 
				 ThreadStr, ExpiredStr, ExpiredStr2, NULL)))
    return sprintf(Buf, "Error running %s - Error %d: %s\n",
		   ProgramPath, errno, strerror(errno));

  len += sprintf(&Buf[len], "%s returned with value %d\n", CUSTOM_AD_CREATE,
		 retval);


  unlink(gConstants.LogFile);

  if ((Fd = fopen(gConstants.LogFile, "w"))) {
    fprintf(Fd, "%10d\n", 0);
    fclose(Fd);
    /*    return 0; */
    len += sprintf(&Buf[len], "Post Log (%s) was reset\n", 
		   gConstants.LogFile);

  }
  else {
    return sprintf(Buf, "Error creating log file %s: %s\n",gConstants.LogFile,
		   strerror(errno));
    
  }

  gConstants.ResetGeneration = 0;
  CreateResetFlag();
  *gConstants.CurrentResetGeneration += 1;

  return(len + sprintf(&Buf[len], "Reset was successful"));
    
}


/* 
 * FUNCTION: int 
 *           CustomAdTextReplace(char *ReplacementStr, char *Text, int Textlen) 
 *
 * PURPOSE:	Scans the Text buffer for WEB99CAD tags, and replaces the
 *		placeholders with real file names based on the 
 * ARGUMENTS:	char       *ReplacementStr
 *					The filename we insert when a tag
 *					is found
 *		char	   *Text        Pointer to text buffer to search
 *		int	   Textlen	Length of Text buffer
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	Name should be preloaded with the path to the file_set.
 *              The filenames inside the tag specify file_set and further.
 *		
 */


int 
CustomAdTextReplace(char *ReplacementStr, char *Text, int Textlen) {

  char *pInc;

#define ASIZE 128 
          int i,n,j; 
	  static int qs_bc[ASIZE];
	  static char *x = CAD_SCAN_STR;
	  static int aflag;

          pInc = Text;
         
          if (0 == aflag) {
	    /* Preprocessing */
            for (i=0; i < ASIZE; i++) qs_bc[i]=SZ_CAD_SCAN_STR+1;
            for (i=0; i < SZ_CAD_SCAN_STR; i++) qs_bc[x[i]]=SZ_CAD_SCAN_STR-i;
	    aflag = 1;
	  }
         
          /* Searching */
          i=0;
          while (i <= Textlen - LSZ_CAD_SCAN_STR) {
	     j = 0;
	     while ( j < (SZ_CAD_SCAN_STR - 1)  ) {
		if (Text[i+j] != x[j]) break;
		j++;
	     }
             if ( j == (SZ_CAD_SCAN_STR - 1) ) {
		pInc = &Text[i] + CAD_REPLACE_LOC;   
		/*memcpy(pInc, ReplacementStr, SZ_CAD_FILENAME);*/
		for (n = 0; n <= SZ_CAD_FILENAME - 1; n++) {
			*pInc++ = *ReplacementStr++;
		}
	     }
	     
/******      if (memcmp(&Text[i], CAD_SCAN_STR, SZ_CAD_SCAN_STR) == 0) { **/
/******                pInc = &Text[i] + CAD_REPLACE_LOC;		 **/
/******                memcpy(pInc, ReplacementStr, strlen(ReplacementStr)); */
/******	     }  */

             i+=qs_bc[Text[i + SZ_CAD_SCAN_STR]];    /* shift */
          }

	return (0);
}


int
ReadCustomData( char *Path, ad_struct_t *AdPtr, int *UserDems, int DataType) {

  FILE *Fd;
  char Record[64];
  
  int RecCt;

  int Id;
  int Dem;
  int AdWt;
  int AdMatch;
  int Expiration;

  if (NULL == (Fd = fopen(Path, "r"))) {
    return -1;
  }

#ifdef DEBUG
  DebugLog("Reading %s file into memory\n", Path);
#endif

  RecCt = 0;
  while (0 != fgets(Record, 64, Fd) ) {
    switch (DataType) {
    case CUSTOM_AD:
      sscanf(Record, "%d %x %x %d %d", &Id, &Dem, &AdWt, &AdMatch, 
	     &Expiration);
      if (Id != RecCt) 
	return -1;
      AdPtr[Id].Dems = Dem;
      AdPtr[Id].GenWt  = (0x000f0000 & AdWt) >> 16;
      AdPtr[Id].AgeWt  = (0x0000f000 & AdWt) >> 12;
      AdPtr[Id].RegWt  = (0x00000f00 & AdWt) >> 8;
      AdPtr[Id].Int1Wt = (0x000000f0 & AdWt) >> 4;
      AdPtr[Id].Int2Wt = 0x0000000f & AdWt;
      AdPtr[Id].Expire = Expiration;
      AdPtr[Id].MinimumMatchWeight = AdMatch;
      break;
    case USER_PERS:
      sscanf(Record, "%d %x", &Id, &Dem);
      if (Id != RecCt)
	return -1;
      UserDems[Id] = Dem;
      break;
    }
    RecCt++;
  }
  fclose(Fd);
return 0;
}


/* 
 * FUNCTION:	int ReadFileIntoBuffer(char *FileNMame, char *Buf, 
 *			               int BufSize)
 *
 * PURPOSE:	Reads a file into the provided buffer.
 *
 * ARGUMENTS:	char	   *FileName    Name of file to get
 *		char       *Buf         Buffer for strings to return to client
 *		int	   BufSize      Size of input buffer
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If the file is too big for the buffer an error is returned.
 *		
 */
int 
ReadFileIntoBuffer(char *FileName, char *Buf, int BufSize) {

  int Desc;
  int Len = 0;
  struct stat Stat;
  int ReadLen;

  if ( (Desc = open(FileName, O_RDONLY, NULL)) == -1)
    return sprintf(Buf, "Error opening file '%s': %s", FileName, 
		   strerror(errno));

  do  {
      /* Loop on read until the whole file is in the Buffer */
      ReadLen = read (Desc, (void *) &Buf[Len], BufSize - Len);
      if (ReadLen > 0) {
        Len += ReadLen;
        if (Len == BufSize) break;
        continue;
      }
      else if (ReadLen < 0 ) {
        /* On read error, get out of the loop */
        Len = sprintf(Buf, "Error reading file '%s': %s", FileName,
                      strerror(errno));
        break;
      }
  } while (Len < BufSize && ReadLen > 0);
  
  close(Desc);
  Buf[Len] = '\0';
  return Len;
  
}


/* 
 * FUNCTION:	int RunProgram(char *Path, ...)
 *
 * PURPOSE:     Runs the specified program in a forked process. 
 *		Returns to the caller only after the other program finishes.
 *
 * ARGUMENTS:	char       *Path        Path of the program to run
 *		...			The same arguments that execv expects
 *
 * RETURNS:	0 if all goes well, -1 if it doesn't
 *
 * COMMENTS:	Zeus processes ignore (SIG_IGN) the signal SIGCHLD,
 *		so we turn it on momentarily to wait for the child
 *		to finish .
 *		
 */

int
RunProgram(char *Path, ...){
  va_list ap;
  char *Args[100];
  int argno = 0;
  int Status;
  int ChildPid;

  
  char Buf[400];

  if ( -1 == (ChildPid = fork())) {
    return -1;
  }

  if (0 == ChildPid) {
    int Ret;
    va_start(ap, Path);
    while ((Args[argno++] = va_arg(ap, char *)) != (char *) 0)
      ;
    va_end(ap);
    Ret = execv(Path, Args);

    /* If the execv works this return shouldn't get executed */
    return Ret;
  }
  else {
    int Ret;
    
    struct sigaction NewSa;
    struct sigaction OldSa;

    NewSa.sa_handler = SIG_DFL;
    NewSa.sa_mask = 0;
    NewSa.sa_flags = SA_RESETHAND;

    /* Need to enable SIGCHLD for this to work */
    sigaction(SIGCHLD, &NewSa, &OldSa);
    Ret = waitpid( ChildPid, &Status, 0);
    sigaction(SIGCHLD, &OldSa, &NewSa);

    if (Ret == -1) 
      return Ret;
    else
      return 0;
  }
}



/* 
 * FUNCTION:	int WriteLog(spec_data_t *pContext, post_struct_t *pPost,
 *			     int *File)
 *
 * PURPOSE:	Assembles the post data into a string and writes it to the
 *		end of the post log.  Increments the record count at the
 *		top of the log.
 *		
 *		
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		post_struct_t *pPost    Sturcture with parsed POST input
 *              char       *File	File accessed
 *
 * RETURNS:	Number of bytes written to post log (not including record count)
 *		or -1 if the write had an error
 *     
 *
 * COMMENTS:	The post log is locked during the file operations in order
 *		to keep the log consistent.
 *		
 */
int
WriteLog (spec_data_t *pContext, post_struct_t *pPost, char *File) {
  char *Ptr;
  char Tmp[PATH_MAX];
  char Count[11];
  int Len;
  int Time;
  int Desc;

  if ((Desc = open (gConstants.LogFile, O_RDWR)) == -1) 
    return -1;

  if (gConstants.TimePtr != NULL) 
	Time = *gConstants.TimePtr;
  else
  	Time = time(NULL); 

  flock(Desc, LOCK_EX);

  /* Read the current count and increment it */
  read( Desc, (void *) Tmp, 10);
  Tmp[10] = '\0';
  sprintf(Count, "%10d", atoi(Tmp) + 1);
  lseek( Desc, 0, SEEK_SET);
  write( Desc, Count, 10);

  /* Go to the end of file, and add a POST record */
  lseek (Desc, 0, SEEK_END);
  Len = sprintf(Tmp, "%10d %10d %10d %5s %2s %2s %10s %-60.60s %10d %10s\n",
	  atoi(Count),  Time, gConstants.Pid, pPost->Dir, pPost->Class, 
	  pPost->Num, pPost->Client, File, gConstants.Pid, pPost->Cookie); 



  Len = write(Desc, Tmp, Len);

  flock(Desc, LOCK_UN);

  close(Desc);
  return Len;

}

    
CreateResetFlag ( ) {
    int fd;
    static long count=0;

    fd = open( RESET_FLAG_PATH, O_EXCL|O_RDWR|O_CREAT, 0666 );
    if ( fd >= 0 ) {
        count += 1;
        write (fd, &count, sizeof(long));
    }
    else {
         fd = open( RESET_FLAG_PATH, O_RDWR|O_CREAT, 0666 );
         if ( fd < 0) return (-1);
    }
    gConstants.CurrentResetGeneration =
        mmap( NULL, sizeof(long), (PROT_WRITE|PROT_READ),
                 (MAP_FILE|MAP_VARIABLE|MAP_SHARED), fd, (off_t) 0 );
    if ( gConstants.CurrentResetGeneration == (long *) -1 ) {
        return (-1);
    }
    close(fd);
    return (0);
}


/*+***************************************************************************/
/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-newzisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-zisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

void
GetPostData(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  int BytesRead;
  int BytesToRead;

  /* Check if data is available already -- it usually is in IIS
     and isn't in Zeus */
  if (pEcb->cbTotalBytes == pEcb->cbAvailable) {
    memcpy(pContext->Inbuf, (char *)pEcb->lpbData, pEcb->cbTotalBytes);
    pContext->Inbuf[pEcb->cbTotalBytes] = '\0';
  }

  else {
    BytesRead = 0;
    BytesToRead = pEcb->cbTotalBytes;
    
    if ( (int)pEcb->cbTotalBytes >= pContext->InbufLen) {
      pContext->Inbuf = realloc(pContext->Inbuf, pEcb->cbTotalBytes);
      pContext->InbufLen = pEcb->cbTotalBytes;
    }
    
    while (BytesRead != (int) pEcb->cbTotalBytes) {
      pEcb->ReadClient(pEcb->ConnID, &pContext->Inbuf[BytesRead], 
		       &BytesToRead);
      
      BytesRead += BytesToRead;
      BytesToRead = pEcb->cbTotalBytes - BytesRead;
    }
    pContext->Inbuf[BytesRead] = '\0';
#ifdef DEBUG
    DebugLog("Inbuf = %s\n", pContext->Inbuf);
#endif
  }
}


int 
GetQuery(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  char OtherVars[256];
  char *pStr, *cStr;
  int BufLen;
  int Request;

  BufLen = 128;

  pEcb->GetServerVariable( pEcb->ConnID, "REMOTE_ADDR", pContext->RemoteAddr,
			   &BufLen);

  pContext->QueryString = (char *)pEcb->lpszQueryString;
  pContext->QueryMethod = (char *)pEcb->lpszMethod;

  /* Determine if there's a Cookie involved */
  BufLen = 256;
  cStr = pContext->CookieStr;
  *cStr = '\0';
  OtherVars[0] = '\0';

  if ( pEcb->GetServerVariable( pEcb->ConnID, "HTTP_COOKIE", OtherVars,
			   &BufLen)) {
     pStr = OtherVars;
     if (0 == strncmp (OtherVars, MYCOOKIE_STR, SZ_MYCOOKIE_STR) ) {
      /* Skip past HTTP_COOKIE:[ ]my_cookie= part of the string and grab
         the useful portion of the cookie string */
        strcpy (pContext->CookieStr, OtherVars + SZ_MYCOOKIE_STR);
     }
  }

  /* Parse the command */
  Request = NO_QUERY;
  if (0 == strncmp("GET", pContext->QueryMethod, 3)) {
      Request = GET_PAGE;
      if (0 != strncmp("command/", pContext->QueryString, 8)) {
        if ( '\0' != pContext->CookieStr[0] ) Request = GET_CAD;
        } else if (!strncmp(&pContext->QueryString[8],"Reset",5)) {
          Request = CMD_RESET;
        } else if (!strncmp (&pContext->QueryString[8], "Fetch", 5) ) {
          Request = CMD_FETCH;
        } else if (!strncmp(&pContext->QueryString[8], "Version", 7) ) {
          Request = CMD_VERSION;
        }
  } else if (0 == strncmp("POST", pContext->QueryMethod, 4)) {
    Request = POST_PAGE;
  }

#ifdef DEBUG
  DebugLog("GetQuery Query=%s, Meth=%s\n\t Cookie=%s, Addr=%s\n",
	   pContext->QueryString, pContext->QueryMethod, pContext->CookieStr,
	   pContext->RemoteAddr);
#endif

  return Request;
}

/* 
 * FUNCTION:	int Initialize(EXTENSTION_CONTROL_BLOCK *pEcb, 
 *              spec_data_t *pContext)
 *
 * PURPOSE:	Initializes the web_data structure using the inputs
 *              provided by Zeus in the pEcb structure.
 *		
 * ARGUMENTS:	EXTENSION_CONTROL_BLCOK
 *			   *pEcb	ISAPI structure contain "environment"
 *                                      variables and "methods" for getting/
 *                                      returning data.
 *		spec_data_t *pContext	Context structure
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	
 *              
 *		
 */
int 
Initialize(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  int BufLen, sz;
  /* If we have a problem in initialization, we need to format an error 
     string -- this HTML header is enought */
  const char HtmlHeader[] = "<html>\n"\
    "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"\
    "<body>\n"\
    "<pre>\n";


  if (! pContext->Buffer) {
    pContext->Buffer = (void *)malloc(BUFLEN);
  }
  if (0 == pContext->Buffer) {
    pContext->Buffer = gConstants.PanicPage;
    pContext->BufCurLen = sprintf(gConstants.PanicPage,
	      "%sCan't malloc Buffer of size %d: %s", HtmlHeader, BUFLEN, 
	      strerror(errno));
				   
  }  
  /* pEcb->GetServerVariable() is how you get environment variables */
  BufLen = sizeof(gConstants.ServerSoftware);
  pEcb->GetServerVariable( pEcb->ConnID, "SERVER_SOFTWARE", 
			   gConstants.ServerSoftware, &BufLen);
  gConstants.LenServerSoftware = strlen(gConstants.ServerSoftware);

  BufLen = sizeof(gConstants.ScriptName);
  pEcb->GetServerVariable( pEcb->ConnID, "SCRIPT_NAME", gConstants.ScriptName,
			   &BufLen);
  gConstants.LenScriptName = strlen(gConstants.ScriptName);
  
  if (pEcb->lpszPathTranslated[0] == '\0') 
    memcpy(gConstants.TopDir, DEFAULT_TOP_DIR, DEFAULT_TOP_DIR_LEN + 1);
  else
    strcpy(gConstants.TopDir, pEcb->lpszPathTranslated);
  
  
  gConstants.LenTopDir = strlen(gConstants.TopDir);
  memcpy(pContext->FileName,gConstants.TopDir, gConstants.LenTopDir);
  
  sprintf(gConstants.LogFile, "%s/post.log", POST_LOG_DIR);
  
  sprintf(gConstants.UserPersFile, "%s/%s", gConstants.TopDir, USER_PERS_FILE);
  sprintf(gConstants.CustomAdFile, "%s/%s", gConstants.TopDir, CUSTOM_AD_FILE);
  
  pContext->Inbuf = malloc(INBUF_INITIAL_LEN);
  pContext->InbufLen = INBUF_INITIAL_LEN;

  gConstants.Pid = getpid();
  
  gConstants.LastAdReadTime = 0;
  /**  gConstants.ResetGeneration = 0;  **/
  gConstants.CurrentResetGeneration = NULL;
  if (gConstants.CurrentResetGeneration == NULL) {
	gConstants.ResetGeneration = 0;
  	/*CreateResetFlag();*/
  }

      sz = sizeof( gConstants.TimePtr );
      if ( pEcb->ServerSupportFunction( pEcb->ConnID, HSE_REQ_GET_TIMEPTR,
                                  &gConstants.TimePtr, &sz, 0 ) == FALSE ) {
         gConstants.TimePtr = NULL ;
      }

  return 0;
}


/* 
 * FUNCTION:	int ReturnPostLog(char *LogFile, char *HtmlStart,
 *				  EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	Returns the post log.  The post log can be huge, so
 *		it is read and returned in 8192 byte chuncks.
 *
 * ARGUMENTS:	char	   *LogFile     Path of Post Log
 *		char       *HtmlStart   Start of HTML page for returning log
 *		EXTENSION_CONTROL_BLOCK
 *			   *pEcb	Control block containing info on
 *					client connection
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	None
 *
 */

int 
ReturnPostLog (char *LogFile, char *HtmlStart, WebInputs_t *Inputs) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  int Desc;
  struct stat Stat;
  int HtmlLength;
  const char HeaderFormat[] = "Content-Type: text/html\nContent-Length: %d\n\n";
  char Header[256];
  int HeaderLen;
  int StartLen;
  int EndLen;

  char Buf[SEND_SIZE];
  int BytesSent;
  int BytesRead;

  /* Open the logfile and read the record count */
  if ((Desc = open(LogFile, O_RDONLY)) == -1)
    sprintf(Buf, "Error opening log file '%s': %s\n",
	    LogFile, strerror(errno));
  else {
    fstat(Desc, &Stat);
    StartLen = strlen(HtmlStart);
    HtmlLength = Stat.st_size + StartLen + SZ_BOILERPLATE_END;

    HeaderLen = sprintf(Header, HeaderFormat, HtmlLength);
    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;

    pEcb->WriteClient( pEcb->ConnID, HtmlStart, &StartLen, 0);

    for (BytesSent = 0; BytesSent < Stat.st_size; BytesSent += BytesRead) {
      BytesRead = read(Desc, (void *)Buf, SEND_SIZE);
      pEcb->WriteClient( pEcb->ConnID, Buf, &BytesRead, 0);
    }

    pEcb->WriteClient( pEcb->ConnID, BOILERPLATE_END, &EndLen, 0);
  }
  return HSE_STATUS_SUCCESS;
}


int
FinishHtmlAndSendBuffer(WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;
  int EndLen;
  int HeaderLen;
  char Header[128] = HTTP_HEADER_START;
  char *p;

  memcpy(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_END, SZ_BOILERPLATE_END);
  pContext->BufCurLen += SZ_BOILERPLATE_END;



  /* Return headers. */
  p = Header + SZ_HTTP_HEADER_START;

  /*
  p += MyItoaPos(pContext->BufCurLen + 1, p, 10);
  */
  p += MyItoaPos(pContext->BufCurLen, p, 10);


  if (pContext->CookieStr[0] == '\0') {
    memcpy(p, "\r\n\r\n\0", 5);
    HeaderLen = p - Header + 4;
    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				     HSE_REQ_SEND_RESPONSE_HEADER, 0,
				     &HeaderLen, (LPDWORD)Header) )

    return HSE_STATUS_ERROR;
  }

  else {
    *p++ = '\n'; 
    memcpy(p, HTTP_SETCOOKIE_START, SZ_HTTP_SETCOOKIE_START + 1);
    strcpy(p + SZ_HTTP_SETCOOKIE_START, pContext->CookieStr);
    HeaderLen = p - Header + SZ_HTTP_SETCOOKIE_START + 1
      + strlen(pContext->CookieStr);

    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;
  }


  /* Return complete page */
#ifdef DEBUG
  HeaderLen = pContext->BufCurLen;
#endif
  pEcb->WriteClient( pEcb->ConnID, pContext->Buffer, &pContext->BufCurLen, 0);
#ifdef DEBUG
  if (pContext->BufCurLen != HeaderLen) 
    DebugLog("Bytes in WriteClient: %d NE Bytes in buffer: %d\n", pContext->BufCurLen, HeaderLen);
#endif
  return HSE_STATUS_SUCCESS;
}


int
TransmitFile (WebInputs_t *Inputs, spec_data_t *pContext) {

  EXTENSION_CONTROL_BLOCK *pEcb = (EXTENSION_CONTROL_BLOCK *) Inputs;

  HSE_TF_INFO tf;

  char Header[128];
  int HeaderLen;
  int Error;

  /* If we were given a cookie, then we need to return one, too */
  if (pContext->CookieStr[0] != '\0') {

    memcpy(Header, HTTP_SETCOOKIE_XMIT_START, 
	   SZ_HTTP_SETCOOKIE_XMIT_START + 1);
    strcpy(Header + SZ_HTTP_SETCOOKIE_XMIT_START , 
	   pContext->CookieStr);
    HeaderLen = SZ_HTTP_SETCOOKIE_XMIT_START + 
      strlen(pContext->CookieStr);

    if (! pEcb->ServerSupportFunction( pEcb->ConnID, 
				       HSE_REQ_SEND_RESPONSE_HEADER, 0,
				       &HeaderLen, (DWORD *) Header) )
      return HSE_STATUS_ERROR;
  }
  

  pContext->Buffer[pContext->BufCurLen] = '\0';
  memset(&tf, 0, sizeof(tf));
  /* Brute force method for getting the necessary data into a buffer
     it would be more efficient to allocate the buffer to begin with,
     then write into it */


  pEcb->ServerSupportFunction(pEcb->ConnID, HSE_REQ_ALLOC_MEM, &tf.pHead, 
			&pContext->BufCurLen,0);
  memcpy(tf.pHead, pContext->Buffer, pContext->BufCurLen);
  tf.HeadLength = pContext->BufCurLen;
  tf.pTail = (PVOID) BOILERPLATE_END;
  tf.TailLength = SZ_BOILERPLATE_END;


  tf.dwFlags = HSE_IO_SEND_HEADERS | HSE_IO_DISCONNECT_AFTER_SEND |
    HSE_IO_HANDLE_IS_FILENAME;

  tf.hFile = (HANDLE)pContext->FileName;

#ifdef DEBUG
  DebugLog("In Transmit File and header = %s, strlen=%d sizeof=%d\n", tf.pHead,
	   tf.TailLength, SZ_BOILERPLATE_END);
#endif 

  if (!pEcb->ServerSupportFunction(pEcb->ConnID, HSE_REQ_TRANSMIT_FILE,
				   &tf, 0, 0)) {
    return MY_TRANSMIT_FILE_ERROR;
  }

#ifdef DEBUG
  if (pContext->BufCurLen != (int) strlen(pContext->Buffer)) 
    DebugLog("%s:Bytes in Header: %d NE Bytes in buffer: %d\n", pContext->BufCurLen, strlen(pContext->Buffer));
#endif

  return HSE_STATUS_SUCCESS;
}


/*
  Convert an int to an ASCII string, returning the string length
*/

int MyItoaPos( int val, char *buf, int radix) {

  char *p;                /* pointer to traverse string */
  char *firstdig;         /* pointer to first digit */
  char temp;              /* temp char */
  unsigned digval;        /* value of digit */
  int len;
  
  p = buf;
  
  firstdig = p;           /* save pointer to first digit */
  
  do {
    digval = (unsigned) (val % radix);
    val /= radix;       /* get next digit */
    
    /* convert to ascii and store */
    if (digval > 9)
      *p++ = (char) (digval - 10 + 'a');  /* a letter */
    else
      *p++ = (char) (digval + '0');       /* a digit */
  } while (val > 0);
  
  /* We now have the digit of the number in the buffer, but in reverse
     order.  Thus we reverse them now. */
  
  len = p - firstdig;


  *p-- = '\0';            /* terminate string; p points to last digit */
  


  do {
    temp = *p;
    *p = *firstdig;
    *firstdig = temp;   /* swap *p and *firstdig */
    --p;
    ++firstdig;         /* advance to next two digits */
  } while (firstdig < p); /* repeat until halfway */

  return len;
}


int
set_nonblock_flag(int desc, int value) {
  int oldflags = fcntl (desc, F_GETFL, 0);
  if (oldflags == -1) 
    return -1;
  if (value !=  0)
    oldflags |= O_NONBLOCK;
  else
    oldflags &= ~O_NONBLOCK;
  return fcntl(desc, F_SETFL, oldflags);
}

/* 
 * FUNCTION:	void DebugLog (char *Format, ...) 
 *
 * PURPOSE:	Writes debug records to a log file
 *
 * ARGUMENTS:	same as printf
 *
 * RETURNS:	None.
 *
 * COMMENTS:	Log file name is <top_dir>/weblog_<pid>
 *
 */

/*#ifdef DEBUG*/
void
DebugLog (char *Format, ...) {

  va_list VarArgs;

  if (LogFd == 0 ) {
    char FileName[256];
    sprintf(FileName, "%s/weblog_%d", DEFAULT_TOP_DIR, getpid());
    LogFd = fopen(FileName, "w");
  }

  /* Expand the format string and arg uments */
  if( NULL != Format ) {
    va_start( VarArgs , Format);
    vfprintf( LogFd, Format, VarArgs );
    va_end( VarArgs );
    fflush(LogFd);
  }

}
/*#endif*/


/* 
 * FUNCTION:	BOOL WINAPI GetExtensionVersion(HSE_VERSION_INFO *pVer)
 *
 * PURPOSE:	ISAPI call that gets executed once when the calling 
 *		process loads this library
 *
 * ARGUMENTS:	HSE_VERSION_INFO  *pVer  passed in structure for setting
 *					 version and description
 *
 * RETURNS:	TRUE
 *
 * COMMENTS:	For more info on ISAPI coding refer to
 *		http://www.microsoft.com/WIN32DEV/APIEXT/ISAPIMRG.HTM
 *
 */
BOOL WINAPI
GetExtensionVersion (HSE_VERSION_INFO *pVer) {
  pVer->dwExtensionVersion = HSE_VERSION_MAJOR;
  strcpy (pVer->lpszExtensionDesc, "SPECweb99 Dynamic GET & POST Test");

  return TRUE;
}

/* 
 * FUNCTION:	DWORD WINAPI HttpExtensionProc(EXTENSION_CONTROL_BLOCK *pEcb)
 *
 * PURPOSE:	ISAPI call that gets executed for every client request to
 *		this library.  This is ISAPI's equivalent to main().
 *
 * ARGUMENTS:	EXTENSION_CONTROL_BLOCK  *pEcb  
 *					passed in structure with variables
 *					and function pointers
 *
 * RETURNS:	HSE_STATUS_SUCCESS, HSE_STATUS_ERROR
 *
 * COMMENTS:	For more info on ISAPI coding refer to
 *		http://www.microsoft.com/WIN32DEV/APIEXT/ISAPIMRG.HTM
 *
 */

DWORD WINAPI
HttpExtensionProc (EXTENSION_CONTROL_BLOCK *pEcb) {


  return Specweb99main((WebInputs_t *)pEcb);
}

