#ifndef __WINTYPES_H
#define __WINTYPES_H

/*!
 * \file
 * \brief Windows data types

   This file is basically for additions and alterations to the
   standard ISAPI header files.  A lot of the stuff is for defining
   Windows types on Unix. */

#ifndef WIN32
/* define windows types on Unix  */
typedef int   BOOL;
typedef char* LPSTR;
typedef const char * LPCSTR;
typedef void* LPVOID;
typedef void* PVOID;
typedef void  VOID;
typedef int*  LPDWORD;
typedef int   DWORD;
typedef char  CHAR;
typedef unsigned char* LPBYTE;
typedef short WORD;
typedef char  BYTE;
typedef long  LONG;
typedef void* HANDLE;

#define TRUE  1
#define FALSE 0

#define WINAPI

int GetLastError();
int SetLastError();

#define NO_ERROR 0
#define ERROR_INVALID_PARAMETER 1
#define ERROR_INVALID_INDEX    2
#define ERROR_INSUFFICIENT_BUFFER 3
#define ERROR_MORE_DATA 4
#define ERROR_NO_DATA   5

#define MAKEWORD(a, b) ((WORD) (((BYTE) (a)) | ((WORD)  ((BYTE) (b))) << 8))
#define MAKELONG(a, b) ((LONG) (((WORD) (a)) | ((DWORD) ((WORD) (b))) << 16))

/*! \brief Reason codes for DllMain function. */
/* typedef enum { */
#define DLL_PROCESS_ATTACH 0 /*\!< loading library (before Get*Version) */
#define DLL_THREAD_ATTACH  1 /*\!< attaching a thread */
#define DLL_THREAD_DETACH  2 /*\!< detaching from a thread */
#define DLL_PROCESS_DETACH 3 /*\!< about to unload (after Terminate*) */
/* } DLL_MAIN_REASON; */

#else
#include <windows.h>
#endif /* !WIN32 */


typedef void* HCONN;

#ifndef HINSTANCE
#define HINSTANCE void*
#endif

/*! \brief type of DllMain() function (q.v., below). */

typedef BOOL WINAPI (*DllMainf)
   ( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved );

/*! \brief DllMain - DLL initialisation function.

  This optional function may be supplied by a handler (extension or filter).  It
  will be ignored when the handler is run in-process: but when run
  out-of-process, if present it is called by the runner to initialise and
  finalise the shared library and each thread using it.  In ZWS's use of it,
  hinstDLL and lpvReserved will always be NULL (i.e. 0); fdwReason will be one
  of the DLL_... reason codes listed above.  Return value is ignored except when
  fdwReason is DLL_PROCESS_ATTACH: a FALSE return from this call will abort
  loading of the library. */

extern BOOL WINAPI
DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved );

#endif
