/*++

     Copyright (c) 1998 Microsoft Corporation

     Spin lock related routines

     Module Name: spinlock.hxx

     Created: Neel Jain (njain). Based on Dmitry's spinlock.

     Modified:
     TYhuang: make it compile under VC++


--*/

#ifndef _SPINLOCK_HXX_
#define _SPINLOCK_HXX_

#include <windows.h>
#include "define.h"

typedef volatile ULONG SpinLock;

/*
#define InterlockedCompareExchangePrivate(Destination, ExChange, Comperand) \
    (LONG)InterlockedCompareExchange((PVOID *)(Destination), (PVOID)(ExChange), (PVOID)(Comperand))

#define InterlockedCompareExchangePointerPrivate(Destination, ExChange, Comperand) \
    InterlockedCompareExchange(Destination, ExChange, Comperand)
*/

#define InterlockedCompareExchangePrivate(Destination, ExChange, Comperand) \
    InterlockedCompareExchange((Destination), (ExChange), (Comperand))

#define InterlockedCompareExchangePointerPrivate(Destination, ExChange, Comperand) \
    InterlockedCompareExchangePointer(Destination, ExChange, Comperand)


// Initialize a spinlock
__inline void InitSpinLock(SpinLock *sl)
{
    *sl = SL_FREE;
}

// Acquire a spinlock with spinning count = SL_SPINCOUNT
__inline void AcquireSpinLock(SpinLock *sl)
{
	ULONG i;

    while (1) {
        
        for (i = 0; i <= SL_SPINCOUNT; i++)
        {
            if (*sl == SL_FREE) {
                
                if (SL_FREE == InterlockedCompareExchangePrivate((PLONG)sl, SL_LOCKED, SL_FREE)) {
                    return;
                }
                
            }
        }

        SwitchToThread();
        
    }
}


__inline void ReleaseSpinLock(SpinLock *sl)
{
    *sl = SL_FREE;
}

#endif
