/*
 * zeus-cgi.c - implementation of SPECweb99 Standard Dynamic CGI GET request
 * Optimised for Zeus Web Server 3.3.8 and above
 *
 * (c) Zeus Technology Limited 2000-2002.  All rights reserved.
 * 
 * Copyright in the source code ("the Source Code") listed below in whatever
 * form, whether printed electronic compiled or otherwise, belongs to Zeus
 * Technology Limited ("we"/"us").
 * 
 * If you have entered into a written agreement with us under which the Source
 * Code is licensed to you ("Licence"),  you may not use, sell, license,
 * transfer, copy or reproduce the Source Code in whole or in part or in any
 * manner or form other than in accordance with your Licence.  To do so is
 * strictly prohibited and may be unlawful and a serious criminal offence.
 * 
 * If you have not entered into a Licence, disclosure of the Source Code is
 * made "as is".   You may use the Source Code for non-commercial purposes
 * only.  You may distribute the Source Code to individual third parties for
 * their non-commercial purposes only, but only if (1) you acknowledge our web
 * site as the source of the Source Code and include such acknowledgement and
 * our web address (www.zeus.com) in any copy of the Source Code; (2) the
 * Source Code you distribute is complete and not modified in any way and
 * includes this notice; and (3) you inform such third parties that these
 * conditions apply to them and that they must comply with them.
 * 
 * If you have not entered into a Licence, all express and implied warranties,
 * conditions, terms, undertakings and representations, including without
 * limitation as to quality, performance, fitness for purpose, or
 * non-infringement, are excluded to the fullest extent permitted by law.
 * Neither we nor any other person involved in disclosing the Source Code shall
 * have any liabilities whatsoever to you, howsoever arising, in connection
 * with the Source Code, or its use by you.
 * 
 * If you have not entered into a Licence but would like to do so,  please
 * contact us at pepp@zeus.com.
 */


/* 
 * If you have sendfile() support, then uncomment the appropriate line for
 * your platform to use it.
 * Using sendfile() may or may not be faster depending on your platform,
 * so experiment with some trial runs first instead of blindly enabling it!
 *
 * On some platforms, it is enabled by default in the Configure script.
 */

/*#define USE_SENDFILE_HP*/
/*#define USE_SENDFILE_AIX*/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/uio.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>

#if defined(USE_SENDFILE_HP) || defined(USE_SENDFILE_AIX)
#include <sys/socket.h>
#endif

static const char msg1[] =
   "HTTP/1.0 200 OK\nContent-Type: text/html\n"
   "Content-Length: ";
static const int msg1_len = sizeof( msg1 ) - 1;

static const char msg2[] =
   "<html>\n"
   "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n"
   "<body>\n"
   "<p>SERVER_SOFTWARE = ";
static const int msg2_len = sizeof( msg2 ) - 1;

static const char msg3[] =
   "\n"
   "<p>REMOTE_ADDR = ";
static const int msg3_len = sizeof( msg3 ) - 1;

static const char msg4[] =
   "\n"
   "<p>SCRIPT_NAME = ";
static const int msg4_len = sizeof( msg4 ) - 1;

static const char msg5[] =
   "\n"
   "<p>QUERY_STRING = ";
static const int msg5_len = sizeof( msg5 ) - 1;

static const char msg6[] =
   "\n<pre>\n";
static const int msg6_len = sizeof( msg6 ) - 1;

/* Not const, since this gets used as the sendfile() trailer. */
static char msg7[] =
   "\n</pre>\n</body></html>\n";
static const int msg7_len = sizeof( msg7 ) - 1;

static void error( const char* format, ... )
{
   va_list args;
   va_start( args, format );
   printf( "Content-Type: text/plain\n\nError: " );
   vprintf( format, args );
   printf( "\n" );
   va_end( args );
   exit( 1 );
}

#define MIN(a, b) ((a < b) ? (a) : (b))
#define MAX_CONTENT_LENGTH 10

#ifdef IRIX64
/* Irix64's libc doesn't have an snprintf() function, so provide a simple
 * emulation. (We lose the safety, but it shouldn't be an issue for
 * SPECweb99 anyway.)
 */
int snprintf( char *str, size_t size, const char *format, ... )
{
   va_list args;
   int ret;

   va_start( args, format );
   ret = vsprintf( str, format, args );
   va_end( args );

   return ret;
}
#endif

int main()
{
   char hdr[1024];
   struct stat st;
   struct iovec vec[3];
   char content_length[MAX_CONTENT_LENGTH];
   char* server_software;  int server_software_len;
   char* remote_addr;      int remote_addr_len;
   char* script_name;      int script_name_len;
   char* query_string;     int query_string_len;
   char* docroot;          int docroot_len;
   int fd;
   int len, l;

   server_software     = getenv( "SERVER_SOFTWARE" );
   server_software_len = strlen( server_software );
   remote_addr         = getenv( "REMOTE_ADDR" );
   remote_addr_len     = strlen( remote_addr );
   script_name         = getenv( "SCRIPT_NAME" );
   script_name_len     = strlen( script_name );
   query_string        = getenv( "QUERY_STRING" );
   query_string_len    = strlen( query_string );
   docroot             = getenv( "DOCUMENT_ROOT" );
   docroot_len         = strlen( docroot );
   if( !docroot )        error( "No DOCUMENT_ROOT" );

   /* open filename */
   strcpy( hdr, docroot );
   strcat( hdr, query_string );
   fd = open( hdr, O_RDONLY );
   if( fd == -1 ) error( "open failed: %s", strerror( errno ));
   if( fstat( fd, &st ) == -1 ) error( "fstat failed: %s", strerror( errno ));
   /* Include \n\n here and not in one of the msg* arrays to make it easier
    * to calculate the content-length. */
   snprintf( content_length, MAX_CONTENT_LENGTH, "%d\n\n",
             msg2_len + server_software_len +
                msg3_len + remote_addr_len +
                msg4_len + script_name_len +
                msg5_len + query_string_len +
                msg6_len + (int)st.st_size +
                msg7_len );

   /* build header */
   len = 0;
   memcpy( hdr,       msg1, msg1_len );          len += msg1_len;
   l = strlen( content_length );
   memcpy( hdr + len, content_length, l );       len += l;
   memcpy( hdr + len, msg2, msg2_len );          len += msg2_len;
   l = server_software_len;
   memcpy( hdr + len, server_software, l );      len += l;
   memcpy( hdr + len, msg3, msg3_len );          len += msg3_len;
   l = remote_addr_len;
   memcpy( hdr + len, remote_addr, l );          len += l;
   memcpy( hdr + len, msg4, msg4_len );          len += msg4_len;
   l = script_name_len;
   memcpy( hdr + len, script_name, l );          len += l;
   memcpy( hdr + len, msg5, msg5_len );          len += msg5_len;
   l = query_string_len;
   memcpy( hdr + len, query_string, l );         len += l;
   memcpy( hdr + len, msg6, msg6_len );          len += msg6_len;

   /* Send the response. There is some code here that is frustratingly close
    * to common, but the interfaces to sendfile() and friends differ enough
    * across platforms that it's awkward to merge them cleanly.
    */
   {

#if defined(USE_SENDFILE_HP)
      ssize_t w, ww;
      off_t pos = 0;
      vec[0].iov_base = hdr;
      vec[0].iov_len  = len;
      vec[1].iov_base = msg7;
      vec[1].iov_len  = msg7_len;
      while( pos != st.st_size ) {
	 w = sendfile( 1, fd, pos, st.st_size - pos, vec, 0 );
	 if( w == -1 ) {
	    if( errno == EINTR )
	       continue;
	    else
               error( "sendfile failed: %s", strerror( errno ));
	 }
	 ww = w;
	 if( vec[0].iov_len != 0 ) {
	    const int done = MIN( ww, (int)vec[0].iov_len );
	    vec[0].iov_base = (char *)vec[0].iov_base + done;
	    vec[0].iov_len -= done;
	    ww             -= done;
	 }
	 if( ww && pos != st.st_size ) {
	    const int done = MIN( ww, (int)(st.st_size - pos) );
	    pos           += done;
	    ww            -= done;
	 }
	 if( ww ) {
	    /* Anything left over here must be from the trailer. */
	    vec[1].iov_base = (char *)vec[1].iov_base + ww;
	    vec[1].iov_len -= ww;
	 }
      }
      /* We don't do sendfile() for the trailer, if it hasn't been written by
       * now; instead, just write().
       */
      while( vec[1].iov_len > 0 ) {
	 w = write( 1, vec[1].iov_base, vec[1].iov_len );
	 if( w == -1 ) {
	    if( errno == EINTR )
	       continue;
	    else
               error( "write failed: %s", strerror( errno ));
	 }
	 vec[1].iov_base = (char *)vec[1].iov_base + w;
	 vec[1].iov_len -= w;
      }

#elif defined(USE_SENDFILE_AIX)
      struct sf_parms sf_iobuf;
      int socket = 1;
      int ret;
      sf_iobuf.header_data     = hdr;
      sf_iobuf.header_length   = len;
      sf_iobuf.file_descriptor = fd;
      sf_iobuf.file_offset     = 0;
      sf_iobuf.file_bytes      = st.st_size;
      sf_iobuf.trailer_data    = msg7;
      sf_iobuf.trailer_length  = msg7_len;
      while( (ret = send_file( &socket, &sf_iobuf, 0 )) != 0 )
	 /* AIX send_file() updates the sf_parms struct for us. */
	 if( ret == -1 ) {
	    if( errno == EINTR )
	       continue;
	    else
	       error( "send_file failed: %s", strerror( errno ));
	 }

#else   
      void *addr;
      ssize_t w, ww;
      addr = mmap( (caddr_t) 0, st.st_size, PROT_READ, MAP_SHARED, fd, 0 );
      if( addr == MAP_FAILED )
         error( "mmap failed: %s", strerror( errno ));
      vec[0].iov_base = hdr;
      vec[0].iov_len  = len;
      vec[1].iov_base = addr;
      vec[1].iov_len  = st.st_size;
      vec[2].iov_base = msg7;
      vec[2].iov_len  = msg7_len;
      while( vec[2].iov_len != 0 ) {
	 w = writev( 1, vec, 3 );
	 if( w == -1 ) {
	    if( errno == EINTR )
	       continue;
	    else
	       error( "writev failed: %s", strerror( errno ));
	 }
	 ww = w;
	 if( vec[0].iov_len != 0 ) {
	    const int done  = MIN( ww, (int)vec[0].iov_len );
	    vec[0].iov_base = (char *)vec[0].iov_base + done;
	    vec[0].iov_len -= done;
	    ww -= done;
	 }
	 if( ww && vec[1].iov_len != 0 ) {
	    const int done  = MIN( ww, (int)vec[1].iov_len );
	    vec[1].iov_base = (char *)vec[1].iov_base + done;
	    vec[1].iov_len -= done;
	    ww -= done;
	 }
	 if( ww ) {
	    /* Anything left over here must be from the trailer. */
	    vec[2].iov_base = (char *)vec[2].iov_base + ww;
	    vec[2].iov_len -= ww;
	 }
      }
#endif

   }
   _exit( 0 );
}

