
/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 * All rights reserved
 *
 * Specweb99 dynamic content generation plugin 
 * 
 */

#pragma ident "@(#)server.c    1.0 01/03/04    SMI"


#include <alloca.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <synch.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <nsapi.h>
#include <prio.h>
#include <sys/sendfile.h>
#include <drnsapi.h>

#define BUFFER_MAX 930000   /* 1024*900=921600 */
#define PATH_MAX 256

#define RESERVE_HDR 1024
#define MAX_CADS 359
#define RECSIZE 139

#define UP_REC_LEN 15
#define CAD_REC_LEN 39

char *LOGFILE;
char *TOPDIR;
char *UPFILE;
char *CADFILE;
char *SCRIPT_NAME;
int SCRIPT_NAME_LEN;
int TOPDIRLEN;
int SCAN1_skip[256]; /* boyer-moore skip array */

#define GENDER_MASK	0x30000000
#define AGE_GROUP_MASK	0x0f000000
#define REGION_MASK	0x00f00000
#define INTEREST1_MASK	0x000ffc00
#define INTEREST2_MASK	0x000003ff

#define TOPDIR_ERROR "Can't find top of document tree, please \
configure value CGI script manually.\n"

const char* lastBuf = "\n</pre>\n</body></html>\n";
const int lastLen = 23; 

#define SCAN1 "<!WEB99CAD><IMG SRC=\"/file_set/dir"
#define SCAN1_LEN (sizeof(SCAN1)-1)
#define SCAN2 "NNNNN/classX_Y"
#define SCAN2_LEN (sizeof(SCAN2)-1)
#define SCAN3 "\"><!/WEB99CAD>"
#define SCAN3_LEN (sizeof(SCAN3)-1)

typedef struct {
    char *buffer;
    size_t maxlen;
    size_t buflen;
    size_t usrval1;
}buffer_t;

typedef struct cookie_struct {
  int count, pid, dir, class, num, client, cookie;
  time_t ts;
  char *fname;
} cookie_struct;


typedef struct customAd_struct {
  int ad_demo, gender_wt, age_group_wt;
  int region_wt, int1_wt, int2_wt;
  int min_match_val, expiration;
} customAd_struct;

extern int errno;

/* global variabnes */
customAd_struct customAds[MAX_CADS + 1];
int *ups;
int upslen;
int cadlen;
time_t last_read_up_st_mt=-1;
time_t last_read_cad_st_mt=-1;
rwlock_t rwLogLock;
/*mutex_t cntLock;*/

int logfd = -1;
int upfd = -1;
int cadfd = -1 ; 
int pid;
char *server_software;
int server_software_len;

/*
 * dosplit_1 - split a string at "&" or "="
 */
char *
dosplit_1 (char **str) 
{
  char *ptr, *ret;
  
  ptr = *str;
  ret = NULL;
  
  while (1) {
    if (*ptr == 0 || *ptr == '&' || *ptr == '=') {
      ret = *str;
      *ptr++ = 0;
      break;
    }
    ptr++;
  }
  *str = ptr;
  
  return ret;
}

char *
dosplit_2 (char **str)
{
  char *ptr, *ret;
  int i;
  int len = strlen(*str);
  
  ptr = *str;
  ret = NULL;
  
  for (i = 0; i < len+1; i++) {
    if (*ptr == 0 || *ptr == '&' || *ptr == '=') {
      ret = *str;
      *ptr++ = 0;
      break;
    }
    ptr++;
  }
  if (i < len)
    *str = ptr;
  else
    *str = ptr-1;
  
  return ret;
}


static char *
append_uint(char *p, int i)
{
#define MAXDIGITS       11
  char buf[MAXDIGITS + 1];
  char *bp = buf + MAXDIGITS;
  int i1;
  
  if (i < 10) {
    *p++ = (char)(i + '0');
    
    return p;
  }
  
  *bp = '\0';
  
  do {
    i1 = i;
    i /= 10;
    
    *--bp = (char)(i1 - i * 10 + '0');
  }
  while (i > 9);
  
  *--bp = (char)(i + '0');
  
  while (*bp != '\0') {
    *p++ = *bp++;
  }
  
  return p;
}

static char *
append_uint_zero(char *p, int i, int digs)
{
#define MAXDIGITS       11
  char buf[MAXDIGITS + 1];
  char *bp = buf + MAXDIGITS;
  int i1;
  
  *bp = '\0';
  
  if (i > 9) {
    do {
      i1 = i;
      i /= 10;
      
      *--bp = (char)(i1 - i * 10 + '0');
    }
    while (i > 9);
  }
  
  *--bp = (char)(i + '0');
  
  for (i = digs - (MAXDIGITS - (bp - buf)); i > 0; i--) {
    *p++ = '0';
  }
  
  while (*bp != '\0') {
    *p++ = *bp++;
  }

  return p;
}


static char *
append_uint_space(char *p, int i, int digs)
{
#define MAXDIGITS       11
  char buf[MAXDIGITS + 1];
  char *bp = buf + MAXDIGITS;
  int i1;

  *bp = '\0';

  if (i > 9) {
    do {
      i1 = i;
      i /= 10;
      
      *--bp = (char)(i1 - i * 10 + '0');
    }
    while (i > 9);
  }

  *--bp = (char)(i + '0');

  for (i = digs - (MAXDIGITS - (bp - buf)); i > 0; i--) {
    *p++ = ' ';
  }
  
  while (*bp != '\0') {
    *p++ = *bp++;
  }

  return p;
}

/* trailing semicolon comes from invocation */
#define append(p, s) q = s; while (*q) *p++ = *q++
#define appendc(p, c) *p++ = c

#define FIRST_PART1 "<html>\n<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n<body>\n<p>SERVER_SOFTWARE = "
#define FIRST_PART2 "\n<p>REMOTE_ADDR = "
#define FIRST_PART3 "\n<p>SCRIPT_NAME = "
#define FIRST_PART4 "\n<p>QUERY_STRING = "
#define FIRST_PART5 "\n<pre>\n"

int
create_hdrs_n_firstbuf(Session *sn, Request *rq, char *p, int content_len_excl,
                       char *cookie)
{
  int first_len;
  char *remote_address  = pblock_findval("ip", sn->client);
  /* char *script_name = pblock_findval("path", rq->vars); */
  char *query_string = pblock_findval("query", rq->reqpb);
  char *startp = p;
  char *q;
  
  first_len = sizeof(FIRST_PART1 FIRST_PART2 FIRST_PART3 FIRST_PART4 FIRST_PART5) - 1;
  if (remote_address == NULL)
    remote_address = "\t";
  if (query_string == NULL)
    query_string = "\t";
  first_len += strlen(remote_address) + SCRIPT_NAME_LEN + 
    server_software_len + strlen(query_string);
  
  append(p, "HTTP/1.0 200 OK\r\n" \
	 "Content-Type: text/html\r\n" \
	 "Connection: close\r\n" \
	 "Content-Length: ");
  p = append_uint(p, content_len_excl + first_len);
  appendc(p, '\r');
  appendc(p, '\n');
  if (cookie) {
    append(p, "Set-Cookie: ");
    append(p, cookie);
    append(p, "\r\n");
  }
  appendc(p, '\r');
  appendc(p, '\n');
  
  append(p, FIRST_PART1);
  append(p, server_software);
  append(p, FIRST_PART2);
  append(p, remote_address);
  append(p, FIRST_PART3);
  append(p, SCRIPT_NAME);
  append(p, FIRST_PART4);
  append(p, query_string);
  append(p, FIRST_PART5);
  
  return p - startp;
}

int sendfile_correct_without_nca (Session *sn, Request *rq, char *filename) 
{
  int fd;
  struct stat st;
  int retval, errLen;
  char errorBuf[256];
  char *outbuf;

  fd = open(filename, O_RDONLY);
  if (fd < 0) {
    errLen = sprintf(errorBuf, "Error opening file '%s'.\n", filename);
    return sendbuf(sn, rq, 0, errorBuf, errLen);
  }

  fstat (fd, &st);
  outbuf = (char *)malloc(st.st_size); 
  retval = read(fd, outbuf, st.st_size);	
  close (fd);
  
  if (retval != st.st_size) {
    errLen = sprintf (errorBuf, "Error (%d) reading file '%s'.\n", 
                      errno, filename);
    return sendbuf(sn, rq, 0, errorBuf, errLen);
  }
  retval = sendbuf(sn, rq, 0, outbuf, st.st_size);
  free (outbuf);	
  return retval;
}	

int sendbuf (Session *sn, Request *rq, char* cookieBuf, 
             char *msgBuf, int msgLen) 
{
  struct iovec iov[3];
  char firstBuf[512];
  int firstLen;
  
  firstLen = create_hdrs_n_firstbuf(sn, rq, firstBuf, msgLen+lastLen, 
				    cookieBuf);
  
  iov[0].iov_base = firstBuf;
  iov[0].iov_len = firstLen;
  iov[1].iov_base = msgBuf;
  iov[1].iov_len = (msgBuf ? msgLen : 0);
  iov[2].iov_base = lastBuf;
  iov[2].iov_len = lastLen;
  
  rq->status_num = PROTOCOL_OK;
  rq->request_is_cacheable = 0;
  pblock_nvinsert("status", (const char *)"OK", rq->srvhdrs);
  rq->senthdrs = 1;
  KEEP_ALIVE(rq) = 0;
  
  if (net_writev(sn->csd, iov, 3) == IO_ERROR) {
    log_ereport(LOG_FAILURE, "Writev failed");
    return REQ_ABORTED;
  }

  return REQ_PROCEED;
}

int sendfile (Session *sn, Request *rq, char* cookieBuf, char *filename) 
{
  
  char firstBuf[512];
  int firstLen;
  int sockfd, srcfd;
  struct stat st;
  ssize_t byteSent;
  size_t xfered;
  sendfilevec_t sfv[3];
  PRFileDesc *srcFd;
  FcHdl hDl;
 
  if ((srcFd = fc_open(filename, &hDl, 0, sn, rq)) == NULL) { 
    log_ereport(LOG_FAILURE, "open failed for %s", filename);
    return REQ_ABORTED;
  }
  srcfd = net_native_handle(srcFd);
  
  firstLen = create_hdrs_n_firstbuf(sn, rq, firstBuf, hDl.fileSize+lastLen, 
				    cookieBuf);
  
  sfv[0].sfv_fd = SFV_FD_SELF;
  sfv[0].sfv_flag = 0;
  sfv[0].sfv_off = (long)firstBuf;
  sfv[0].sfv_len = firstLen;
  
  sfv[1].sfv_fd = srcfd;
  sfv[1].sfv_flag = 0;
  sfv[1].sfv_off = 0;
  sfv[1].sfv_len = hDl.fileSize;
  
  sfv[2].sfv_fd = SFV_FD_SELF;
  sfv[2].sfv_flag = 0;
  sfv[2].sfv_off = (long)lastBuf;
  sfv[2].sfv_len = lastLen;
  
  sockfd = net_native_handle(sn->csd);
  byteSent = sendfilev(sockfd, &sfv, 3, &xfered);
  
  fc_close(srcFd, &hDl);
  
  rq->status_num = PROTOCOL_OK;
  rq->request_is_cacheable = 0;
  pblock_nvinsert("status", (const char *)"OK", rq->srvhdrs);
  
  rq->senthdrs = 1;
  KEEP_ALIVE(rq) = 0;
  
  return REQ_PROCEED;
}

int read_UPCAD_file() {

  struct stat up_st, cad_st;
  int i1, i2, uID, userdemo;
  char buf[256];

  if (upfd < 0 || cadfd < 0)
    if ( ((upfd = open (UPFILE, O_RDONLY)) < 0) ||
         ((cadfd = open (CADFILE, O_RDONLY)) < 0) )
      goto read_UPCAD_err;

  if (fstat(upfd, &up_st)<0)
      goto read_UPCAD_err;
  if (fstat(cadfd, &cad_st)<0)
      goto read_UPCAD_err;
  if ((cad_st.st_mtime <= last_read_cad_st_mt) 
      && (up_st.st_mtime <= last_read_up_st_mt)) {
    return REQ_PROCEED;
  } 

  lseek (upfd, 0, SEEK_SET);
  lseek (cadfd, 0, SEEK_SET);

  upslen = up_st.st_size / UP_REC_LEN;
  cadlen = cad_st.st_size / CAD_REC_LEN;
  last_read_up_st_mt = up_st.st_mtime;
  last_read_cad_st_mt = cad_st.st_mtime;
  if (ups)
    free (ups);
  ups = malloc (sizeof(int) * upslen);
 
  for (i1 = 0; i1 < upslen; i1++) {
    if (read(upfd, buf, UP_REC_LEN) == UP_REC_LEN) {
      sscanf(buf, "%d %x", &uID, &userdemo);
      ups[uID] = userdemo;
    }
    else {
      goto read_UPCAD_err;
    }
  }  

  for (i2 = 0; i2 < cadlen; i2++) {
    if (read(cadfd, buf, CAD_REC_LEN) == CAD_REC_LEN) {
      int ad_id, adDemo,weight,min_match_val,expiration;
      sscanf(buf, "%d %x %x %d %d", &ad_id, &adDemo,
             &weight, &min_match_val, &expiration);
      customAds[ad_id].min_match_val = min_match_val;
      customAds[ad_id].expiration=expiration;
      customAds[ad_id].ad_demo = adDemo;
      customAds[ad_id].gender_wt = (weight & 0x000f0000) >>16;
      customAds[ad_id].age_group_wt = (weight& 0x0000f000) >>12;
      customAds[ad_id].region_wt = (weight & 0x00000f00) >>8;
      customAds[ad_id].int1_wt = (weight & 0x000000f0) >>4;
      customAds[ad_id].int2_wt = (weight & 0x0000000f);
    }
    else {
      goto read_UPCAD_err;
    }
  }  

  return REQ_PROCEED;

read_UPCAD_err: 
  return REQ_ABORTED;

}

int getCustomAdID(int userDemo, int last_ad, time_t now, int *pWeight, 
                  int *pExpired)
{
  int ad_index, ad_weight;
  int combinedDemo;
  customAd_struct *pAD;
  struct timeval tv;
  
  /* search all the custom ads for the first on whose weight 
   * is greater than its minimum match value */
  for (ad_index = last_ad + 1, pAD = &(customAds[ad_index]); 
       ad_index != last_ad; ad_index++, pAD++) {
    if ( ad_index > MAX_CADS) {
      ad_index = 0;
      pAD = &(customAds[0]);
    }
    
    combinedDemo = pAD->ad_demo & userDemo;
    ad_weight = 0;
    
    if (combinedDemo & GENDER_MASK)
      ad_weight += pAD->gender_wt;
    if (combinedDemo & AGE_GROUP_MASK)
      ad_weight += pAD->age_group_wt;
    if (combinedDemo & REGION_MASK)
      ad_weight += pAD->region_wt;
    if (combinedDemo & INTEREST1_MASK)
      ad_weight += pAD->int1_wt;
    if (combinedDemo & INTEREST2_MASK)
      ad_weight += pAD->int2_wt;
    if (ad_weight >= pAD->min_match_val)
      break;
  }
  
  *pExpired = (now > pAD->expiration);
  *pWeight = ad_weight;
  
  return ad_index;
}

int customAdRotation(Session *sn, Request *rq, int user_id, int last_ad, 
		     char* scanfile)
{
  int uid = user_id - 10000;		
  int ad_index;
  int ad_wt;
  int expired;
  char found[256];

  
  if (uid < 0 || uid >= upslen || last_ad < 0) {
    sprintf (found, "found_cookie=Ad_id=-1&Ad_weight=00&Expired=1");
  } else {
    if (upslen <= 0) {
      /* open up file error */
      sprintf (found, "found_cookie=Ad_id= -9&Ad_weight=00&Expired=0");
      return sendbuf(sn, rq, found, "upslen ERROR", 12);
    }
    if (cadlen <= 0 || cadlen > MAX_CADS +1) {
      /* open cad file error */
      sprintf (found, "found_cookie=Ad_id= -1&Ad_weight=00&Expired=2");
      return sendbuf(sn, rq, found, "cadlen ERROR", 12);
    }
    
    ad_index = getCustomAdID(ups[uid], last_ad, REQ_TIME(rq),&ad_wt, &expired);
    
    sprintf (found,"found_cookie=Ad_id=%d&Ad_weight=%d&Expired=%d", 
	     ad_index, ad_wt, expired);
  }
  return sendfile(sn, rq, found, scanfile);
}


#define STACKLIMIT 32768

int customAdRotation_replace (Session *sn, Request *rq, int user_id, 
			      int last_ad, char* scanfile)
{
  int retval;
  
  int uid = user_id - 10000;		
  int userdemo; 
  int ad_index;
  char overwrtfnm[15];
  char *buf, *str1, *str2, *str3, *str4;
  int ad_wt;
  int expired;
  int reqdbuf_len = 0, retv;
  int dir, rem, x, y, l;
  int k, j, i;
  char *q;
  unsigned char *reqdbuf;
  int fd;
  struct stat st;
  char found[256];
  unsigned char stackbuffer[STACKLIMIT];
  int offset;
  FcHdl hDl;
  PRFileDesc *Fd;
  
  
  if (upslen <= 0) {
    sprintf (found,"found_cookie=Ad_id= -9&Ad_weight=00&Expired=0");
    return sendbuf(sn, rq, found, "upslen ERROR", 12);
  }
  
  if (cadlen <= 0 || cadlen > MAX_CADS +1) {
    sprintf (found,"found_cookie=Ad_id= -1&Ad_weight=00&Expired=2");
    return sendbuf(sn, rq,found, "cadlen ERROR", 12);
  }
 
  if ((Fd = fc_open(scanfile, &hDl, 0, sn, rq)) == NULL) {
    return sendbuf(sn, rq,found, "open Error", 10);
  } 
  fd = net_native_handle(Fd);

  if (hDl.fileSize > STACKLIMIT) {
    reqdbuf = (unsigned char*)malloc(hDl.fileSize);
    if (reqdbuf == NULL) {
      perror ("malloc");
      exit(1);
    }
  } else {
    reqdbuf = stackbuffer;
  }
  reqdbuf_len = 0;
  while (reqdbuf_len != hDl.fileSize) {
    retv = pread(fd, reqdbuf+reqdbuf_len, hDl.fileSize-reqdbuf_len,0);
    if (retv <= 0) 
      break;
    reqdbuf_len += retv;
  }
  fc_close (Fd, &hDl);
  
  if (uid >= 0 && uid < upslen && last_ad >= 0) {
    ad_index = getCustomAdID(ups[uid], last_ad, REQ_TIME(rq),&ad_wt, &expired);
    sprintf (found,"found_cookie=Ad_id=%d&Ad_weight=%d&Expired=%d",
	     ad_index, ad_wt, expired);
  } else {
    ad_index = last_ad + 1;
    if (ad_index > MAX_CADS) {
      ad_index = 0;
    }	
    sprintf (found,"found_cookie=Ad_id=-1&Ad_weight=00&Expired=1");
  }
  dir = ad_index / 36;
  rem = (ad_index - (dir<<5) - (dir<<2));
  x = rem / 9;            /* 0 <= x <= 3 */
  y = rem - (x<<3) - x;   /* 0 <= y <= 8 */
  
  /* replace SCAN2 (NNNNN/classY_Z) with overwrtfnm */ 

  k = SCAN1_LEN - 1;
  while (k < reqdbuf_len) {
    /* try to match from the last char to the first */
    for (j=SCAN1_LEN-1, i=k;  j>=0 && reqdbuf[i] == SCAN1[j];  j--)
      i--;
    if (j != -1) {
      /* not found - play boyer-moore */
      k += SCAN1_skip[reqdbuf[k]];
      continue;
    }

    q = (char *)reqdbuf + i + 1 + SCAN1_LEN;
    /* q now points to after the occurence of SCAN1 we found */
    q = append_uint_zero(q, dir, 5);
    q[6] = x + '0';
    q[8] = y + '0';
    /* reset search beyond the whole tag */
    k += SCAN1_LEN + SCAN2_LEN + SCAN3_LEN;
  }

  retval = sendbuf(sn, rq, found, (char *)reqdbuf, reqdbuf_len);

 
  if (hDl.fileSize > STACKLIMIT)
    free(reqdbuf);
  
  return retval;
  
}

#define SPECWEB_NSAPI "/specweb99-nsapi"
#define SPECWEB_NSAPI_LEN sizeof(SPECWEB_NSAPI)-1
NSAPI_PUBLIC int
ntrans_service_specweb99(pblock *pb, Session *sn, Request *rq)
{
  int res = REQ_NOACTION; 
  char* uri = pblock_findval("uri", rq->reqpb);
  if (uri && (strncmp(uri, SPECWEB_NSAPI, SPECWEB_NSAPI_LEN) == 0)) {
    /* this is a request for the nsapi part */
    service_specweb99(pb, sn, rq);
    return REQ_ABORTED;
  }
  return res;
}

NSAPI_PUBLIC int
service_specweb99(pblock *pb, Session *sn, Request *rq)
{
  char *str1, *str2, *str3, *str4;
  char *p, *q, c;
  int l, len;
  int my_cookie, last_ad;
  int fd, i1, i2, retval;
  char cmdline[256];
  char *max_load, *pt_time, *max_thread, *exp_list;
  char *filename;
  int logCount;
  int logoffset;
  struct stat cad_st;
  
  char *query_string = pblock_findval("query", rq->reqpb);
  char *cookie = pblock_findval("cookie", rq->headers);
  
  char cookieBuf[256];
  char errorBuf[256];
  char record[RECSIZE+1];
  int firstLen;
  
  my_cookie = last_ad = 0;
  
  /* find user_id and last_ad */ 
  if (cookie) {
    /* get to cookie contents */
    if ((str2 = strstr (cookie, "user_id=")) != NULL) {
      str2 += 8;
      my_cookie = atoi(str2);
      
      if ((str2 = strstr (str2, "last_ad=")) != NULL) {
	str2 += 8;
	last_ad = atoi (str2);
      }
    }
  }
	
  /* ===========
   * GET method
   * ===========
   */
  if (rq->method_num == METHOD_GET) {
    if (!query_string ||!(*query_string)) {
      sprintf(errorBuf, "QUERY_STRING not set!\n");
      sendbuf(sn, rq, 0 , errorBuf, strlen(errorBuf));
      log_ereport(LOG_FAILURE, "No query string"); 	
      return REQ_ABORTED;
    }
    
    /* make a writeable copy of the query string (up to the first newline) */
    p = query_string;
    while (*p != '\n' && *p != '\0')
      p++;
    len = p - query_string;
    
    /* need to allocate the trailing \0 as well */
    filename = alloca(len + 1) ; 
    
    p = query_string;
    q = filename;
    l = len;
    while (l--)
      *q++ = *p++;
    *q = '\0';
    
    if (strncmp(filename, "command/", 8) != 0) {
      /* everything not in "command/" is treated as a file */
      /* str1 = concat(TOPDIR, filename) */
      str1 = (char*)alloca(TOPDIRLEN + len + 1);
      p = str1;
      q = TOPDIR;
      while (*q)
	c = *p++ = *q++;
      q = filename;
      if (c == '/' && *q == '/')
	q++;
      while (*q)
	*p++ = *q++;
      *p = '\0';
      
      if (my_cookie != 0) {
        /*
         * ===================================================
         * Dynamic CAD request
         * ===================================================
         */
        if(read_UPCAD_file()==REQ_ABORTED) {
          sprintf(errorBuf, "Error reading file '%s' or '%s' .\n",
                  UPFILE, CADFILE);
          sendbuf(sn, rq, 0, errorBuf, strlen(errorBuf));
          return REQ_ABORTED;
        }

        
	if ((p = strstr(str1, "class")) != NULL && 
	    (p[5] == '1' || p[5] == '2')) {
	  /* class1 and class2 call _replace */
	  retval = customAdRotation_replace(sn, rq,
					  my_cookie, last_ad, str1);
	} else {
	  retval = customAdRotation(sn, rq, 
				  my_cookie, last_ad, str1);
	}
        return retval;
      }
      else {
        /*
         * ===================================================
         * Dynamic GET request
         * ===================================================
         */
	return sendfile(sn, rq, 0, str1);
      }
    } else if (!strncmp(filename, "command/Reset", 13)) {
      /*
       * =======================================================
       * RESET command
       * =======================================================
       */
      str1 = filename;
      str4 = dosplit_1(&str1);
      str4 = dosplit_1(&str1);
      max_load = dosplit_1(&str1)	;
      
      str4 = dosplit_1(&str1);
      pt_time = dosplit_1(&str1);
      
      str4 = dosplit_1(&str1);
      max_thread = dosplit_1(&str1);
      
      str4 = dosplit_1(&str1);
      exp_list = dosplit_1(&str1);
      
      sprintf(cmdline, "%supfgen99 -C %s -n %s -t %s\n",
	      TOPDIR, TOPDIR, max_load, max_thread);
      printf("%s\n", cmdline);
      fflush(stdout);
     
      if ( system(cmdline) < 0 ) {
	perror ("system");
	exit (1);
      }
      
      if (exp_list) {
	for (str4 = exp_list; (*str4); str4++) 
	  if (*str4 == ',')
	    *str4 = ' ';
      }

      sprintf(cmdline, "%scadgen99 -C %s -e %s -t %s %s\n",
	      TOPDIR, TOPDIR, pt_time, max_thread, exp_list);
      printf("%s\n", cmdline);
      fflush(stdout);
     
      if ( system(cmdline) < 0 ) {
	perror ("system");
	exit (1);
      }
      
      /* read the content to the memory */

      if (read_UPCAD_file()== REQ_ABORTED) {
        sprintf(errorBuf, "Error reading file '%s' or '%s' .\n",
                UPFILE, CADFILE);
        sendbuf(sn, rq, 0, errorBuf, strlen(errorBuf));
        return REQ_ABORTED;
      }
      
      rw_wrlock(&rwLogLock);
      
      unlink (LOGFILE);
      
      logfd = open(LOGFILE, O_RDWR|O_TRUNC|O_CREAT, 
                   S_IRWXU | S_IRWXG | S_IRWXO);
      if (logfd <= 0) {
	rw_unlock(&rwLogLock); 
	sprintf(errorBuf,"Error creating file '%s'.\n", LOGFILE);
	sendbuf(sn, rq, 0, errorBuf, strlen(errorBuf));
	return REQ_ABORTED;
      }
      
      logCount = 0;
      sprintf(cmdline, "%10d\n", logCount);
      lseek (logfd, 0, SEEK_SET);
      write(logfd, cmdline, strlen(cmdline));
      rw_unlock(&rwLogLock);
      sendbuf(sn, rq, 0, 0, 0);
      return REQ_PROCEED;
    } else if (!strcmp(filename, "command/Fetch")) {
      /* ==========================================================
       * FETCH command
       * ==========================================================
       */
      rw_wrlock(&rwLogLock);
      close(logfd);
      retval = sendfile_correct_without_nca (sn, rq, LOGFILE);
      rw_unlock(&rwLogLock);
      return retval;
    } else if (!strcmp(filename, "command/Root")) {
      /*
       * ==========================================================
       * ROOT command
       * ==========================================================
       */
      sprintf (errorBuf, "The Document root of this server  is '%s'\n", TOPDIR);
      sendbuf(sn, rq, 0, errorBuf, strlen(errorBuf));
      return REQ_PROCEED;
    } else {
      /*
       * ==========================================================
       * any other command
       * ==========================================================
       */
      /* ...is successfully ignored */
      return REQ_PROCEED;
    }
  } /* end of request method GET */
  else if (rq->method_num == METHOD_POST) {
    /*
     * ==========================================================
     * POST method
     * ==========================================================
     */
    int len, content_len;
    char *dirval, *classval, *numval, *clientval, *urlrootval;
    int dirint, classint, numint, clientint;
    char *name, *value;
    cookie_struct cookie_info;
    netbuf *nbuf;
    int read_len;
    
    str1 = (char *)pblock_findval("content-length", rq->headers);
    len = content_len = atoi(str1);
    
    str2 = alloca(content_len + 1);
    
    nbuf = sn->inbuf;
    read_len = nbuf->cursize - nbuf->pos;

    /* get any data sitting in the buffer */
    if (read_len) {
      if (read_len > content_len) {
	read_len = content_len;
      }
      (void) memcpy(str2, nbuf->inbuf + nbuf->pos, read_len);
      nbuf->pos += read_len;
    }
    
    /* if need to get more data, read from the socket */
    if (read_len < len) {
      len -= read_len;
      read_len = net_read(sn->csd, str2 + read_len, len, 10);
    }
    
    str2[content_len] = 0;
    if (str3 = strchr(str2, '\r'))
      *str3 = 0;
    
    dirval = classval = numval = clientval = urlrootval = 0;
    
    while (*str2) {	
      if ((name = dosplit_2 (&str2)) == NULL)
	break;
      if ((value = dosplit_2(&str2)) == NULL)
	break;
      
      for (str3 = value; *str3; str3++) {
	if (*str3 == '+')
	  *str3 = ' ';
      }
      
      switch (*name) {
      case 'c':
	if (!strcmp(name, "class"))
	  classval = value;
	else if (!strcmp(name, "client"))
	  clientval = value;
	break;
      case 'd':
	if (!strcmp(name, "dir"))
	  dirval = value;
	break;
      case 'n':
	if (!strcmp(name, "num"))
	  numval = value;
	break;
      case 'u':
	if (!strcmp(name, "urlroot"))
	  urlrootval = value;
	break;
      }
    }
    
    if (!dirval || !urlrootval || !classval || !numval || !clientval) {
      sprintf(errorBuf, "POST Content-length: %d\n"
	      "POST doesn't contain complete pathname" 
              "and client information.\n", content_len);
      sendbuf(sn, rq, 0, errorBuf, strlen(errorBuf));
      log_ereport(LOG_FAILURE, "Post screwed up");
      return REQ_ABORTED;
    }
    
    dirint = atoi(dirval);
    classint = atoi(classval);
    numint = atoi(numval);
    clientint = atoi(clientval);
    
    p = cmdline;
    append(p, TOPDIR);
    append(p, urlrootval);
    append(p, "dir");
    p = append_uint_zero(p, dirint, 5);
    append(p, "/class");
    appendc(p, classint + '0');
    appendc(p, '_');
    appendc(p, numint + '0');
    appendc(p, '\0');
    
    rw_wrlock(&rwLogLock);
    pread(logfd, record, 10, 0); 
    record[10]='\0';
    logCount = atoi (record);
    logoffset = 11+logCount*RECSIZE;
    logCount ++;
    sprintf (record,"%10d %10d %10d %5d %2d %2d %10d %-60.60s %10d %10d\n", 
	     logCount, REQ_TIME(rq), pid,
	     dirint, classint, numint, clientint,
	     cmdline + TOPDIRLEN, pid, my_cookie);
    pwrite(logfd, record, RECSIZE, logoffset);
    sprintf(record, "%10d", logCount);
    pwrite(logfd, record, 10, 0);
    rw_unlock(&rwLogLock);
    
    sprintf(cookieBuf, "my_cookie=%d", my_cookie); 
    return sendfile(sn, rq, cookieBuf, cmdline);
  } /* end of POST */ 
  
  return;
}

NSAPI_PUBLIC int init_specweb99(pblock *pb, Session *sn, Request *rq)
{
  char *topdir, *logdir;
  int k;
 
  rwlock_init(&rwLogLock  , USYNC_THREAD, NULL);
  
  pid = getpid();
  server_software = system_version();
  server_software_len = strlen(server_software);
  
  topdir = pblock_findval("topdir", pb);
  if (!topdir) {
    pblock_nvinsert("error", "init_specweb99: please specify topdir -- "
		    "directory under which you configured file_set.", pb);
    return REQ_ABORTED;
  }
  
  TOPDIR = PERM_MALLOC(strlen(topdir) + 2);
  strcpy(TOPDIR, topdir);
  
  if (TOPDIR[strlen(TOPDIR) - 1] != '/')
    strcat (TOPDIR, "/");
  TOPDIRLEN = strlen(TOPDIR);
  SCRIPT_NAME = PERM_MALLOC(TOPDIRLEN + SPECWEB_NSAPI_LEN + 1);
  sprintf(SCRIPT_NAME, "%s%s", TOPDIR, SPECWEB_NSAPI+1);
  SCRIPT_NAME_LEN = strlen(SCRIPT_NAME);
  
  logdir = pblock_findval("logdir", pb);
  if (!logdir) {
    LOGFILE = PERM_MALLOC(strlen(TOPDIR) + 1 + strlen("post.log"));	
    sprintf(LOGFILE, "%s%s", TOPDIR, "post.log");
  }
  else {
    
    LOGFILE = PERM_MALLOC(strlen(logdir) + 2 + strlen("post.log"));
    strcpy(LOGFILE, logdir);
    
    if (LOGFILE[strlen(LOGFILE) - 1] != '/')
      strcat (LOGFILE, "/");
    
    strcat(LOGFILE, "post.log");
  }
  
  if (!(UPFILE=PERM_MALLOC(strlen(TOPDIR)+strlen("User.Personality")+1)))
    goto err;
  sprintf(UPFILE, "%s%s", TOPDIR, "User.Personality");
  
  if (!(CADFILE = PERM_MALLOC(strlen(TOPDIR)+strlen("Custom.Ads")+1)))
    goto err;
  sprintf(CADFILE, "%s%s", TOPDIR, "Custom.Ads");

  /* init boyer-moore skip array */
  /* first, fill everything with length of pattern */
  for (k=0; k<256; k++)
    SCAN1_skip[k] = SCAN1_LEN;
  /* then, for all characters of the pattern, replace skip value */
  /* with offset of this character to the end of the pattern */
  /* the last occurrence of each character (shortest skip) wins */
  for (k=0; k<SCAN1_LEN-1; k++)
    SCAN1_skip[SCAN1[k]] = SCAN1_LEN - k - 1;

  return REQ_PROCEED;
  
 err:
  pblock_nvinsert("error", "init_specweb99: cannot allocate memory", pb);
  return REQ_ABORTED;
}
